/*
 * Decompiled with CFR 0.152.
 */
import cloud.lesh.CPUSim64v2.AsmIO;
import cloud.lesh.CPUSim64v2.AssemblerVisitor;
import cloud.lesh.CPUSim64v2.IncludeLoader;
import cloud.lesh.CPUSim64v2.LabelVisitor;
import cloud.lesh.CPUSim64v2.LiteralRewriter;
import cloud.lesh.CPUSim64v2.PreprocessorVisitor;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Assembler {
    public static void main(String[] args) throws Exception {
        String filename;
        System.out.println("CPUSim64v2 Assembler");
        System.out.println("By Richard Lesh \u00a92025");
        System.out.println("Assembles .asm source files into .obj.gz binary files");
        if (args.length < 1) {
            System.err.println("Usage: assemble [--DEBUG] [-Dsymbol[=value]] <input.asm>");
            System.exit(2);
        }
        Path inPath = Path.of("", new String[0]);
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.charAt(0) == '-') continue;
            inPath = Path.of(arg, new String[0]).toAbsolutePath();
        }
        if (!Files.isRegularFile(inPath, new LinkOption[0])) {
            System.err.println("Can't find file: " + inPath.toString());
            System.exit(3);
        }
        if ((filename = inPath.getFileName().toString()).endsWith(".asm")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        String outName = filename + ".obj.gz";
        Path outPath = inPath.getParent().resolve(outName);
        String source = Files.readString(inPath);
        IncludeLoader loader = new IncludeLoader(inPath.getParent());
        PreprocessorVisitor.resetGlobals();
        Object preprocessed = PreprocessorVisitor.preprocessText(inPath.getFileName().toString(), source, loader, args);
        LiteralRewriter rw = new LiteralRewriter();
        preprocessed = rw.rewrite((String)preprocessed);
        preprocessed = PreprocessorVisitor.addGlobals((String)preprocessed);
        preprocessed = ".org 1" + System.lineSeparator() + (String)preprocessed;
        LabelVisitor labelVisitor = new LabelVisitor();
        String noLabels = labelVisitor.gatherLabels((String)preprocessed);
        List<String> errors = labelVisitor.getErrors();
        if (errors.size() > 0) {
            System.out.println(errors.stream().collect(Collectors.joining(System.lineSeparator())));
            System.exit(2);
        }
        Map<String, Long> labelMap = labelVisitor.getLabelMap();
        Path symbolFile = inPath.getParent().resolve(filename + ".sym");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(symbolFile.toFile()));){
            for (Map.Entry<String, Long> entry : labelMap.entrySet()) {
                writer.write(entry.getKey() + ": " + String.valueOf(entry.getValue()));
                writer.newLine();
            }
        }
        catch (IOException e) {
            System.err.println("Error writing label map: " + e.getMessage());
        }
        AssemblerVisitor asm = new AssemblerVisitor(labelMap);
        asm.assemble(noLabels);
        List<Long> words = asm.result();
        words.set(0, 1L);
        errors = asm.getErrors();
        if (errors.size() > 0) {
            System.out.println(errors.stream().collect(Collectors.joining(System.lineSeparator())));
            System.exit(2);
        }
        AsmIO.writeU64BE(outPath, words);
        System.out.println("Wrote " + words.size() + " words to " + outPath.toString());
        System.exit(0);
    }
}

