/*
 * Decompiled with CFR 0.152.
 */
import cloud.lesh.CPUSim64v2.IncludeLoader;
import cloud.lesh.CPUSim64v2.LiteralRewriter;
import cloud.lesh.CPUSim64v2.PreprocessorVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class Preprocessor {
    public static void main(String[] args) throws Exception {
        String filename;
        System.out.println("CPUSim64v2 Preprocessor");
        System.out.println("By Richard Lesh \u00a92025");
        System.out.println("Preprocesses .asm source files into .pp.asm files");
        if (args.length < 1) {
            System.err.println("Usage: preprocessor <input.asm>");
            System.exit(2);
        }
        Path inPath = Path.of("", new String[0]);
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.charAt(0) == '-') continue;
            inPath = Path.of(arg, new String[0]).toAbsolutePath();
        }
        if (!Files.isRegularFile(inPath, new LinkOption[0])) {
            System.err.println("Can't find file: " + inPath.toString());
            System.exit(3);
        }
        if ((filename = inPath.getFileName().toString()).endsWith(".asm")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        String outName = filename + ".pp.asm";
        Path outPath = inPath.getParent().resolve(outName);
        String source = Files.readString(inPath);
        IncludeLoader loader = new IncludeLoader(inPath.getParent());
        PreprocessorVisitor.resetGlobals();
        Object preprocessed = PreprocessorVisitor.preprocessText(inPath.getFileName().toString(), source, loader, args);
        LiteralRewriter rw = new LiteralRewriter();
        preprocessed = rw.rewrite((String)preprocessed);
        preprocessed = PreprocessorVisitor.addGlobals((String)preprocessed);
        preprocessed = ".org 1" + System.lineSeparator() + (String)preprocessed;
        Files.writeString(outPath, (CharSequence)preprocessed, new OpenOption[0]);
    }
}

