/*
 * Decompiled with CFR 0.152.
 */
import cloud.lesh.CPUSim64v2.AsmIO;
import cloud.lesh.CPUSim64v2.Simulator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Simulation {
    public static void main(String[] args) throws Exception {
        Path originalPath;
        if (args.length < 1) {
            System.err.println("Usage: simulation <input.obj.gz>");
            System.exit(2);
        }
        boolean debug = false;
        boolean verbose = false;
        int memorySize = 0x100000;
        int stackSize = 4096;
        String filespec = "";
        ArrayList<String> simulatorArgs = new ArrayList<String>();
        for (String arg : args) {
            if (arg.charAt(0) == '-') {
                if (arg.equals("--debug")) {
                    debug = true;
                    continue;
                }
                if (arg.equals("--verbose") || arg.equals("-v")) {
                    verbose = true;
                    continue;
                }
                if (arg.startsWith("--mem=")) {
                    try {
                        memorySize = Integer.parseInt(arg.substring("--mem=".length()));
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Invalid memory size: " + arg);
                        System.exit(1);
                    }
                    continue;
                }
                if (arg.startsWith("--stack=")) {
                    try {
                        stackSize = Integer.parseInt(arg.substring("--stack=".length()));
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Invalid stack size: " + arg);
                        System.exit(1);
                    }
                    continue;
                }
                System.err.println("Unknown option: " + arg);
                System.exit(1);
                continue;
            }
            simulatorArgs.add(arg);
        }
        if (verbose) {
            System.out.println("CPUSim64v2 Simulator");
            System.out.println("By Richard Lesh \u00a92025");
            System.out.println("CPUSim64 Virtual Machine");
            System.out.println("Debug: " + debug);
            System.out.println("Memory size: " + memorySize);
        }
        Path newPath = originalPath = Path.of((String)simulatorArgs.get(0), new String[0]).toAbsolutePath();
        Path symbolPath = originalPath;
        Map<String, Long> symbolMap = null;
        HashMap<Long, String> reverseSymbolMap = null;
        String fileName = newPath.getFileName().toString();
        int dot = fileName.indexOf(46);
        String baseName = dot == -1 ? fileName : fileName.substring(0, dot);
        newPath = originalPath.resolveSibling(baseName + ".obj.gz");
        if (!Files.isRegularFile(newPath, new LinkOption[0]) && !Files.isRegularFile(newPath = originalPath.resolveSibling(baseName + ".obj"), new LinkOption[0])) {
            throw new RuntimeException("Can't locate object file for program: " + baseName);
        }
        symbolPath = originalPath.resolveSibling(baseName + ".sym");
        if (!Files.isRegularFile(symbolPath, new LinkOption[0])) {
            System.out.println("Can't locate symbol file for program: " + baseName);
        } else {
            symbolMap = Simulator.readLabelMapFromFile(symbolPath.toFile());
            reverseSymbolMap = new HashMap<Long, String>();
            for (Map.Entry<String, Long> entry : symbolMap.entrySet()) {
                reverseSymbolMap.put(entry.getValue(), entry.getKey());
            }
            if (reverseSymbolMap.get(0L) == null) {
                reverseSymbolMap.put(0L, "__START");
            }
        }
        List<Long> program = AsmIO.readU64BE(newPath.toFile());
        if (verbose) {
            System.out.println("Read " + program.size() + " words from " + newPath.getFileName().toString());
        }
        Simulator sim = new Simulator(memorySize, 0, stackSize, (String[])simulatorArgs.toArray(String[]::new));
        if (debug) {
            sim.setDebug(true);
        }
        sim.loadProgram(program, 0L);
        long result = sim.run(program.get(0), reverseSymbolMap);
        if (verbose) {
            System.out.println("Result: " + result);
        }
    }
}

