/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64v2;

import cloud.lesh.CPUSim64v2.CPUSim64v2BaseVisitor;
import cloud.lesh.CPUSim64v2.CPUSim64v2Lexer;
import cloud.lesh.CPUSim64v2.CPUSim64v2Parser;
import cloud.lesh.CPUSim64v2.CollectingErrorListener;
import cloud.lesh.CPUSim64v2.HasLocation;
import cloud.lesh.CPUSim64v2.Opcode;
import cloud.lesh.CPUSim64v2.Utils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.tuple.Pair;

public class AssemblerVisitor
extends CPUSim64v2BaseVisitor<Void>
implements HasLocation {
    Map<String, Long> labelMap;
    private final Stack<String> blockNames = new Stack();
    String filename = null;
    int lineNum = 1;
    boolean pauseLineIncrement = false;
    private final LinkedList errors = new LinkedList();
    private long blockCount = 0L;
    private final List<Long> out = new ArrayList<Long>();
    private static final int TT_STD = 0;
    private static final int TT_C1 = 1;
    private static final int TT_YC2 = 2;
    private static final int TT_YYC3 = 3;
    private static final int C0_BITS = 12;
    private static final int C1_BITS = 56;
    private static final int C2_BITS = 42;
    private static final int C3_BITS = 28;
    private static final int OT_NONE = 0;
    private static final int OT_CONST = 1;
    private static final int OT_REG = 2;
    private static final int OT_FP = 3;

    @Override
    public String getLocation() {
        return (String)(this.filename == null ? "" : this.filename + ":") + this.lineNum;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public AssemblerVisitor(Map<String, Long> labelMap) {
        this.labelMap = labelMap;
    }

    public List<Long> result() {
        return this.out;
    }

    private long encType0(int opcode, int a, int b, int c, int d, int v0, int v1, int v2, int v3) {
        long w = 0L;
        v0 = (int)this.fitSigned(v0, 12);
        v1 = (int)this.fitSigned(v1, 12);
        v2 = (int)this.fitSigned(v2, 12);
        v3 = (int)this.fitSigned(v3, 12);
        w |= 0L;
        w |= ((long)opcode & 0x3FL) << 56;
        long types = (a & 3) << 6 | (b & 3) << 4 | (c & 3) << 2 | d & 3;
        w |= (types & 0xFFL) << 48;
        w |= (long)(v0 & 0xFFF) << 36;
        w |= (long)(v1 & 0xFFF) << 24;
        w |= (long)(v2 & 0xFFF) << 12;
        return w |= (long)(v3 & 0xFFF);
    }

    private long encType1C1(int opcode, long imm56) {
        long w = 0L;
        imm56 = this.fitSigned(imm56, 56);
        w |= 0x4000000000000000L;
        w |= ((long)opcode & 0x3FL) << 56;
        long masked = imm56 & 0xFFFFFFFFFFFFFFL;
        return w |= masked;
    }

    private long encType2RC2(int opcode, int aType, int op0, long imm42) {
        long w = 0L;
        op0 = (int)this.fitSigned(op0, 12);
        imm42 = this.fitSigned(imm42, 42);
        w |= Long.MIN_VALUE;
        w |= ((long)opcode & 0x3FL) << 56;
        w |= (long)(aType & 3) << 54;
        w |= (long)(op0 & 0xFFF) << 42;
        return w |= imm42 & 0x3FFFFFFFFFFL;
    }

    private long encType3ZZC3(int opcode, int aType, int op0, int bType, int op1, int imm28) {
        long w = 0L;
        op0 = (int)this.fitSigned(op0, 12);
        op1 = (int)this.fitSigned(op1, 12);
        imm28 = (int)this.fitSigned(imm28, 28);
        w |= 0xC000000000000000L;
        w |= ((long)opcode & 0x3FL) << 56;
        w |= (long)(aType & 3) << 54;
        w |= (long)(bType & 3) << 52;
        w |= (long)(op0 & 0xFFF) << 40;
        w |= (long)(op1 & 0xFFF) << 28;
        return w |= (long)(imm28 & 0xFFFFFFF);
    }

    private static int typeCodeForReg() {
        return 2;
    }

    private static int typeCodeForFp() {
        return 3;
    }

    private static int typeCodeForConst() {
        return 1;
    }

    private static int typeCodeNone() {
        return 0;
    }

    private int regIndex(String rText) {
        int idx = Integer.parseInt(rText.substring(1));
        if (idx < 0 || idx > 28) {
            throw new AssemblerException("Register index out of range (0..28): " + rText);
        }
        return idx;
    }

    private int fpIndex(String fText) {
        int idx = Integer.parseInt(fText.substring(1));
        if (idx < 0 || idx > 31) {
            throw new AssemblerException("FP index out of range (0..31): " + fText);
        }
        return idx;
    }

    private int aIndexFromToken(Token t) {
        String s = t.getText().toUpperCase();
        if (s.equals("SF")) {
            return 29;
        }
        if (s.equals("SP")) {
            return 30;
        }
        if (s.equals("PC")) {
            return 31;
        }
        if (s.startsWith("R")) {
            return this.regIndex(s);
        }
        throw new AssemblerException("Not an address-capable register: " + s);
    }

    private long parseIntLike(String text) {
        Long v;
        if (((String)text).startsWith("0x") || ((String)text).startsWith("0X")) {
            return Long.parseUnsignedLong(((String)text).substring(2), 16);
        }
        if (((String)text).startsWith("-0x") || ((String)text).startsWith("-0X")) {
            return -Long.parseUnsignedLong(((String)text).substring(3), 16);
        }
        if (((String)text).charAt(0) == '-' || ((String)text).charAt(0) >= '0' && ((String)text).charAt(0) <= '9') {
            return Long.parseLong((String)text);
        }
        if (((String)text).charAt(0) == '\'') {
            return Utils.parseCharLiteral((String)text);
        }
        if (((String)text).charAt(0) == '@') {
            text = ((String)text).substring(1);
        }
        if (((String)text).charAt(0) == '$') {
            text = ((String)text).charAt(1) == '$' ? this.getLoopScopeName() + ((String)text).substring(1) : this.getScopeName() + (String)text;
        }
        if ((v = this.labelMap.get(((String)text).toUpperCase())) != null) {
            return v;
        }
        throw new AssemblerException("Invalid integer/label: " + (String)text);
    }

    private Pair<Integer, Long> parseOOperand(CPUSim64v2Parser.OOperandContext ctx) {
        long v;
        int d;
        if (ctx == null) {
            d = 1;
            v = 0L;
        } else if (ctx.rOperand() != null) {
            d = 2;
            v = this.regIndex(ctx.rOperand().REG_R().getText());
        } else {
            d = 1;
            v = this.parseIntLike(ctx.cLiteral().getText());
        }
        return Pair.of(d, v);
    }

    private Pair<Pair<Integer, Long>, Pair<Integer, Long>> parseMemRef(CPUSim64v2Parser.MemRefContext ctx) {
        long v1;
        int b;
        int a = 0;
        long v0 = 0L;
        if (ctx.aOperand() != null) {
            a = 2;
            v0 = this.aIndexFromToken(ctx.aOperand().start);
        } else if (ctx.aLiteral() != null) {
            a = 1;
            v0 = this.parseIntLike(ctx.aLiteral().getText());
        }
        if (ctx.rOperand() != null) {
            b = 2;
            v1 = this.regIndex(ctx.rOperand().REG_R().getText());
        } else if (ctx.cLiteral() != null) {
            b = 1;
            v1 = this.parseIntLike(ctx.cLiteral().getText());
        } else {
            b = 0;
            v1 = 0L;
        }
        Pair<Integer, Long> addr = Pair.of(a, v0);
        Pair<Integer, Long> offset = Pair.of(b, v1);
        return Pair.of(addr, offset);
    }

    private int parseZSmall(String text) {
        int v = 0;
        switch (text.toLowerCase()) {
            case "u": {
                return 0;
            }
            case "z": 
            case "eq": {
                return 1;
            }
            case "nz": 
            case "ne": {
                return 2;
            }
            case "n": 
            case "lt": {
                return 3;
            }
            case "p": 
            case "gt": {
                return 4;
            }
            case "nn": 
            case "ge": {
                return 5;
            }
            case "np": 
            case "le": {
                return 6;
            }
            case "o": 
            case "inf": {
                return 7;
            }
            case "no": 
            case "ninf": {
                return 8;
            }
            case "pe": {
                return 9;
            }
            case "po": {
                return 10;
            }
        }
        v = (int)this.parseIntLike(text);
        if (v < 0 || v > 15) {
            throw new AssemblerException("Z out of range (0..15): " + text);
        }
        return v;
    }

    private long fitSigned(long val, int bits) {
        long min = -(1L << bits - 1);
        long max = (1L << bits - 1) - 1L;
        if (val < min || val > max) {
            throw new AssemblerException("Immediate " + val + " does not fit in " + bits + " signed bits");
        }
        long mask = bits == 64 ? -1L : (1L << bits) - 1L;
        return val & mask;
    }

    private int fitUnsigned8(long v) {
        if (v < 0L || v > 255L) {
            throw new AssemblerException("Field needs 8-bit unsigned (0..255): " + v);
        }
        return (int)v;
    }

    private boolean fitsIn(long val, int bits, boolean isSigned) {
        if (isSigned) {
            long min = -(1L << bits - 1);
            long max = (1L << bits - 1) - 1L;
            return val >= min && val <= max;
        }
        return val >= 0L && val <= (1L << bits) - 1L;
    }

    private String getScopeName() {
        return String.join((CharSequence)"$", this.blockNames);
    }

    private String getLoopScopeName() {
        String name;
        int i;
        for (i = this.blockNames.size() - 1; !(i < 0 || (name = ((String)this.blockNames.get(i)).toUpperCase()).startsWith("FOR_") || name.startsWith("WHILE_") || name.startsWith("DO_WHILE_")); --i) {
        }
        return i >= 0 ? String.join((CharSequence)"$", this.blockNames.subList(0, i + 1)) : "";
    }

    @Override
    public Void visitProgram(CPUSim64v2Parser.ProgramContext ctx) {
        for (ParseTree child : ctx.children) {
            try {
                this.visit(child);
            }
            catch (AssemblerException ex) {
                this.errors.add(ex.getMessage());
            }
            if (this.pauseLineIncrement) continue;
            ++this.lineNum;
        }
        return null;
    }

    @Override
    public Void visitInstrNOP(CPUSim64v2Parser.InstrNOPContext ctx) {
        long w = this.encType0(Opcode.NOP.code, 0, 0, 0, 0, 0, 0, 0, 0);
        this.out.add(w);
        return null;
    }

    @Override
    public Void visitInstrDEBUG(CPUSim64v2Parser.InstrDEBUGContext ctx) {
        if (ctx.children.size() == 1) {
            this.out.add(this.encType1C1(Opcode.DEBUG.code, -1L));
        } else if (ctx.y1to4() != null) {
            List<CPUSim64v2Parser.YOperandContext> ys = ctx.y1to4().yOperand();
            int a = 0;
            int b = 0;
            int c = 0;
            int d = 0;
            int v0 = 0;
            int v1 = 0;
            int v2 = 0;
            int v3 = 0;
            for (int i = 0; i < ys.size(); ++i) {
                int v;
                CPUSim64v2Parser.YOperandContext y = ys.get(i);
                boolean isFp = y.fOperand() != null;
                int t = isFp ? 3 : 2;
                int n = v = isFp ? this.fpIndex(y.fOperand().REG_F().getText()) : this.aIndexFromToken(y.aOperand().start);
                if (i == 0) {
                    a = t;
                    v0 = v;
                    continue;
                }
                if (i == 1) {
                    b = t;
                    v1 = v;
                    continue;
                }
                if (i == 2) {
                    c = t;
                    v2 = v;
                    continue;
                }
                d = t;
                v3 = v;
            }
            this.out.add(this.encType0(Opcode.DEBUG.code, a, b, c, d, v0, v1, v2, v3));
        } else {
            int aType = 2;
            long cnt = this.parseIntLike(ctx.cLiteral().getText());
            if (ctx.aOperand() != null) {
                int op0 = this.aIndexFromToken(ctx.aOperand().start);
                this.out.add(this.encType0(Opcode.DEBUG.code, aType, 1, 0, 0, op0, (int)cnt, 0, 0));
            } else if (ctx.aLiteral() != null) {
                long k = this.parseIntLike(ctx.aLiteral().getText());
                this.out.add(this.encType2RC2(Opcode.DEBUG.code, 1, (int)cnt, k));
            } else {
                throw new AssemblerException("DEBUG with C literal needs A or R operand");
            }
        }
        return null;
    }

    @Override
    public Void visitInstrCLEAR(CPUSim64v2Parser.InstrCLEARContext ctx) {
        List xs = ctx.x1to4() == null ? List.of() : ctx.x1to4().xOperand();
        int a = 0;
        int b = 0;
        int c = 0;
        int d = 0;
        int v0 = 0;
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        for (int i = 0; i < xs.size(); ++i) {
            int v;
            CPUSim64v2Parser.XOperandContext x = (CPUSim64v2Parser.XOperandContext)xs.get(i);
            boolean isFp = x.fOperand() != null;
            int t = isFp ? 3 : 2;
            int n = v = isFp ? this.fpIndex(x.fOperand().REG_F().getText()) : this.regIndex(x.rOperand().REG_R().getText());
            if (i == 0) {
                a = t;
                v0 = v;
                continue;
            }
            if (i == 1) {
                b = t;
                v1 = v;
                continue;
            }
            if (i == 2) {
                c = t;
                v2 = v;
                continue;
            }
            d = t;
            v3 = v;
        }
        long w = this.encType0(Opcode.CLEAR.code, a, b, c, d, v0, v1, v2, v3);
        this.out.add(w);
        return null;
    }

    @Override
    public Void visitInstrMOVE(CPUSim64v2Parser.InstrMOVEContext ctx) {
        int a = 0;
        int b = 0;
        int c = 0;
        int d = 0;
        int v0 = 0;
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        if (ctx.zCond() != null) {
            int z = this.parseZSmall(ctx.zCond().getText());
            a = 1;
            v0 = z;
            CPUSim64v2Parser.YOperandContext y = ctx.yOperand(0);
            boolean yIsFp = y.fOperand() != null;
            b = yIsFp ? 3 : 2;
            v1 = yIsFp ? this.fpIndex(y.fOperand().REG_F().getText()) : this.aIndexFromToken(y.aOperand().start);
            CPUSim64v2Parser.QOperandContext q1 = ctx.qOperand(0);
            if (q1.fOperand() != null) {
                c = 3;
                v2 = this.fpIndex(q1.fOperand().REG_F().getText());
            } else if (q1.aOperand() != null) {
                c = 2;
                v2 = this.aIndexFromToken(q1.aOperand().start);
            } else {
                c = 1;
                v2 = (int)this.parseIntLike(q1.cLiteral().getText());
            }
            CPUSim64v2Parser.QOperandContext q2 = ctx.qOperand(1);
            if (q2.fOperand() != null) {
                d = 3;
                v3 = this.fpIndex(q2.fOperand().REG_F().getText());
            } else if (q2.aOperand() != null) {
                d = 2;
                v3 = this.aIndexFromToken(q2.aOperand().start);
            } else {
                d = 1;
                v3 = (int)this.parseIntLike(q2.cLiteral().getText());
            }
            this.out.add(this.encType0(Opcode.MOVE.code, a, b, c, d, v0, v1, v2, v3));
        } else if (ctx.yOperand().size() == 2) {
            CPUSim64v2Parser.YOperandContext y0 = ctx.yOperand(0);
            CPUSim64v2Parser.YOperandContext y1 = ctx.yOperand(1);
            a = y0.fOperand() != null ? 3 : 2;
            v0 = y0.fOperand() != null ? this.fpIndex(y0.fOperand().REG_F().getText()) : this.aIndexFromToken(y0.aOperand().start);
            b = y1.fOperand() != null ? 3 : 2;
            v1 = y1.fOperand() != null ? this.fpIndex(y1.fOperand().REG_F().getText()) : this.aIndexFromToken(y1.aOperand().start);
            this.out.add(this.encType0(Opcode.MOVE.code, a, b, c, d, v0, v1, v2, v3));
        } else if (ctx.yOperand().size() == 1 && ctx.cLiteral() != null) {
            CPUSim64v2Parser.YOperandContext y = ctx.yOperand(0);
            a = y.fOperand() != null ? 3 : 2;
            v0 = y.fOperand() != null ? this.fpIndex(y.fOperand().REG_F().getText()) : this.aIndexFromToken(y.aOperand().start);
            b = 1;
            long k = this.parseIntLike(ctx.cLiteral().getText());
            this.out.add(this.encType2RC2(Opcode.MOVE.code, a, v0, k));
        } else if (ctx.aOperand(0) != null && ctx.aOperand(1) != null && ctx.rOperand() != null) {
            a = 2;
            v0 = this.aIndexFromToken(ctx.aOperand((int)0).start);
            b = 2;
            v1 = this.aIndexFromToken(ctx.aOperand((int)1).start);
            c = 2;
            v2 = this.regIndex(ctx.rOperand().REG_R().getText());
            this.out.add(this.encType0(Opcode.MOVE.code, a, b, c, d, v0, v1, v2, v3));
        } else if (ctx.aOperand(0) != null && ctx.aOperand(1) != null && ctx.aLiteral() != null) {
            a = 2;
            v0 = this.aIndexFromToken(ctx.aOperand((int)0).start);
            b = 2;
            v1 = this.aIndexFromToken(ctx.aOperand((int)1).start);
            c = 1;
            v2 = (int)this.parseIntLike(ctx.aLiteral().getText());
            this.out.add(this.encType3ZZC3(Opcode.MOVE.code, a, v0, b, v1, v2));
        } else if (ctx.aOperand().size() == 2 && ctx.aLiteral() != null) {
            a = 2;
            v0 = this.aIndexFromToken(ctx.aOperand((int)0).start);
            c = 1;
            v2 = (int)this.parseIntLike(ctx.aLiteral().getText());
            b = 2;
            v1 = this.aIndexFromToken(ctx.aOperand((int)1).start);
            this.out.add(this.encType3ZZC3(Opcode.MOVE.code, a, v0, b, v1, v2));
        } else {
            throw new AssemblerException("Unhandled MOVE form");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Void visitInstrLOAD(CPUSim64v2Parser.InstrLOADContext ctx) {
        CPUSim64v2Parser.YOperandContext y = ctx.yOperand();
        boolean yIsFp = y.fOperand() != null;
        int a = yIsFp ? 3 : 2;
        int v0 = yIsFp ? this.fpIndex(y.fOperand().REG_F().getText()) : this.aIndexFromToken(y.aOperand().start);
        int b = 0;
        int c = 0;
        int d = 0;
        long v1 = 0L;
        long v2 = 0L;
        long v3 = 0L;
        Pair<Pair<Integer, Long>, Pair<Integer, Long>> memRef = this.parseMemRef(ctx.memRef());
        b = memRef.getLeft().getLeft();
        c = memRef.getRight().getLeft();
        v1 = memRef.getLeft().getRight();
        v2 = memRef.getRight().getRight();
        if (b == 1 && c == 0) {
            this.out.add(this.encType2RC2(Opcode.LOAD.code, a, v0, v1));
            return null;
        } else if (b == 2 && c == 0) {
            this.out.add(this.encType0(Opcode.LOAD.code, a, b, c, d, v0, (int)v1, (int)v2, (int)v3));
            return null;
        } else if (b == 2 && c == 1) {
            this.out.add(this.encType3ZZC3(Opcode.LOAD.code, a, v0, b, (int)v1, (int)v2));
            return null;
        } else if (b == 1 && c == 2) {
            this.out.add(this.encType3ZZC3(Opcode.LOAD.code, a, v0, c, (int)v2, (int)v1));
            return null;
        } else if (b == 1 && c == 1) {
            if (this.fitsIn(v2, 12, true)) {
                this.out.add(this.encType3ZZC3(Opcode.LOAD.code, a, v0, c, (int)v2, (int)v1));
                return null;
            } else {
                if (!this.fitsIn(v1, 12, true)) throw new AssemblerException("LOAD [C+C] requires one constant to fit in 12 bits");
                this.out.add(this.encType3ZZC3(Opcode.LOAD.code, a, v0, b, (int)v1, (int)v2));
            }
            return null;
        } else {
            if (b != 2 || c != 2) throw new AssemblerException("Unhandled LOAD form");
            this.out.add(this.encType0(Opcode.LOAD.code, a, b, c, d, v0, (int)v1, (int)v2, (int)v3));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Void visitInstrSTORE(CPUSim64v2Parser.InstrSTOREContext ctx) {
        int v0;
        int a;
        CPUSim64v2Parser.QOperandContext q = ctx.qOperand();
        if (q.fOperand() != null) {
            a = 3;
            v0 = this.fpIndex(q.fOperand().REG_F().getText());
        } else if (q.aOperand() != null) {
            a = 2;
            v0 = this.aIndexFromToken(q.aOperand().start);
        } else {
            a = 1;
            v0 = (int)this.parseIntLike(q.cLiteral().getText());
        }
        int b = 0;
        int c = 0;
        int d = 0;
        long v1 = 0L;
        long v2 = 0L;
        long v3 = 0L;
        Pair<Pair<Integer, Long>, Pair<Integer, Long>> memRef = this.parseMemRef(ctx.memRef());
        b = memRef.getLeft().getLeft();
        c = memRef.getRight().getLeft();
        v1 = memRef.getLeft().getRight();
        v2 = memRef.getRight().getRight();
        if (b == 1 && c == 0) {
            this.out.add(this.encType2RC2(Opcode.STORE.code, a, v0, v1));
            return null;
        } else if (b == 2 && c == 0) {
            this.out.add(this.encType0(Opcode.STORE.code, a, b, c, d, v0, (int)v1, (int)v2, (int)v3));
            return null;
        } else if (b == 2 && c == 1) {
            this.out.add(this.encType3ZZC3(Opcode.STORE.code, a, v0, b, (int)v1, (int)v2));
            return null;
        } else if (b == 1 && c == 2) {
            this.out.add(this.encType3ZZC3(Opcode.STORE.code, a, v0, c, (int)v2, (int)v1));
            return null;
        } else if (b == 1 && c == 1) {
            if (this.fitsIn(v2, 12, true)) {
                this.out.add(this.encType3ZZC3(Opcode.STORE.code, a, v0, b, (int)v2, (int)v1));
                return null;
            } else {
                if (!this.fitsIn(v1, 12, true)) throw new AssemblerException("LOAD [C+C] requires one constant to fit in 12 bits");
                this.out.add(this.encType3ZZC3(Opcode.STORE.code, a, v0, b, (int)v1, (int)v2));
            }
            return null;
        } else {
            if (b != 2 || c != 2) throw new AssemblerException("Unhandled LOAD form");
            this.out.add(this.encType0(Opcode.STORE.code, a, b, c, d, v0, (int)v1, (int)v2, (int)v3));
        }
        return null;
    }

    @Override
    public Void visitInstrPOP(CPUSim64v2Parser.InstrPOPContext ctx) {
        if (ctx.yOperand() == null) {
            this.out.add(this.encType0(Opcode.POP.code, 0, 0, 0, 0, 0, 0, 0, 0));
        } else {
            CPUSim64v2Parser.YOperandContext y = ctx.yOperand();
            boolean isFp = y.fOperand() != null;
            int t = isFp ? 3 : 2;
            int v = isFp ? this.fpIndex(y.fOperand().REG_F().getText()) : this.aIndexFromToken(y.aOperand().start);
            this.out.add(this.encType0(Opcode.POP.code, t, 0, 0, 0, v, 0, 0, 0));
        }
        return null;
    }

    @Override
    public Void visitInstrPUSH(CPUSim64v2Parser.InstrPUSHContext ctx) {
        if (ctx.yOperand() != null) {
            CPUSim64v2Parser.YOperandContext y = ctx.yOperand();
            boolean isFp = y.fOperand() != null;
            int aType = isFp ? 3 : 2;
            int v0 = isFp ? this.fpIndex(y.fOperand().REG_F().getText()) : this.aIndexFromToken(y.aOperand().start);
            this.out.add(this.encType0(Opcode.PUSH.code, aType, 0, 0, 0, v0, 0, 0, 0));
        } else {
            long k = this.parseIntLike(ctx.cLiteral().getText());
            this.out.add(this.encType1C1(Opcode.PUSH.code, k));
        }
        return null;
    }

    @Override
    public Void visitInstrJUMP(CPUSim64v2Parser.InstrJUMPContext ctx) {
        this.visitInstrBRANCH(Opcode.JUMP, ctx.branchModes());
        return null;
    }

    @Override
    public Void visitInstrCALL(CPUSim64v2Parser.InstrCALLContext ctx) {
        this.visitInstrBRANCH(Opcode.CALL, ctx.branchModes());
        return null;
    }

    private Void visitInstrBRANCH(Opcode opc, CPUSim64v2Parser.BranchModesContext ctx) {
        boolean hasR;
        if (ctx.zCond() == null) {
            if (ctx.aOperand() != null) {
                int aType = 2;
                int v0 = this.aIndexFromToken(ctx.aOperand().start);
                this.out.add(this.encType0(opc.code, aType, 0, 0, 0, v0, 0, 0, 0));
            } else {
                long k = this.parseIntLike(ctx.cLiteral(0).getText());
                this.out.add(this.encType1C1(opc.code, k));
            }
            return null;
        }
        int z = this.parseZSmall(ctx.zCond().getText());
        boolean aType = true;
        int v0 = z;
        int bType = 0;
        int v1 = 0;
        int imm28 = 0;
        long imm42 = 0L;
        boolean hasA = ctx.aOperand() != null;
        int nC = ctx.cLiteral() == null ? 0 : ctx.cLiteral().size();
        boolean bl = hasR = ctx.rOperand() != null;
        if (hasA && nC == 0 && !hasR) {
            bType = 2;
            v1 = this.aIndexFromToken(ctx.aOperand().start);
            this.out.add(this.encType0(opc.code, 1, bType, 0, 0, v0, v1, 0, 0));
        } else if (!hasA && nC == 1 && !hasR) {
            imm42 = this.parseIntLike(ctx.cLiteral(0).getText());
            this.out.add(this.encType2RC2(opc.code, 1, v0, imm42));
        } else if (hasA && nC == 1 && !hasR) {
            bType = 2;
            v1 = this.aIndexFromToken(ctx.aOperand().start);
            imm28 = (int)this.parseIntLike(ctx.cLiteral(0).getText());
            this.out.add(this.encType3ZZC3(opc.code, 1, v0, bType, v1, imm28));
        } else if (!hasA && nC == 2 && !hasR) {
            long c1 = this.parseIntLike(ctx.cLiteral(0).getText());
            long c2 = this.parseIntLike(ctx.cLiteral(1).getText());
            if (this.fitsIn(c1, 12, true)) {
                bType = 1;
                v1 = (int)c1;
                imm28 = (int)c2;
            } else if (this.fitsIn(c2, 12, true)) {
                bType = 1;
                v1 = (int)c2;
                imm28 = (int)c1;
            } else {
                throw new AssemblerException("JUMP ZCC requires one constant to fit in 12 bits");
            }
            this.out.add(this.encType3ZZC3(opc.code, 1, v0, bType, v1, imm28));
        } else if (hasA && hasR) {
            v1 = this.aIndexFromToken(ctx.aOperand().start);
            int v2 = this.regIndex(ctx.rOperand().REG_R().getText());
            this.out.add(this.encType0(opc.code, 1, 2, 2, 0, v0, v1, v2, 0));
        } else {
            throw new IllegalStateException("Unhandled JUMP conditional form");
        }
        return null;
    }

    @Override
    public Void visitInstrRETURN(CPUSim64v2Parser.InstrRETURNContext ctx) {
        long w = this.encType0(Opcode.RETURN.code, 0, 0, 0, 0, 0, 0, 0, 0);
        this.out.add(w);
        return null;
    }

    @Override
    public Void visitInstrINTERRUPT(CPUSim64v2Parser.InstrINTERRUPTContext ctx) {
        if (ctx.rOperand() != null) {
            int aType = 2;
            long v0 = this.regIndex(ctx.rOperand().REG_R().getText());
            this.out.add(this.encType0(Opcode.INTERRUPT.code, aType, 0, 0, 0, (int)v0, 0, 0, 0));
        } else {
            long v0 = this.parseIntLike(ctx.cLiteral().getText());
            if (this.fitsIn(v0, 12, false)) {
                int aType = 1;
                this.out.add(this.encType0(Opcode.INTERRUPT.code, aType, 0, 0, 0, (int)v0, 0, 0, 0));
            } else {
                this.out.add(this.encType1C1(Opcode.INTERRUPT.code, v0));
            }
        }
        return null;
    }

    @Override
    public Void visitInstrSTOP(CPUSim64v2Parser.InstrSTOPContext ctx) {
        long w = this.encType0(Opcode.STOP.code, 0, 0, 0, 0, 0, 0, 0, 0);
        this.out.add(w);
        return null;
    }

    @Override
    public Void visitInstrNEG(CPUSim64v2Parser.InstrNEGContext ctx) {
        int v0;
        int aType;
        if (ctx.xOperand().fOperand() != null) {
            aType = 3;
            v0 = this.fpIndex(ctx.xOperand().fOperand().REG_F().getText());
        } else if (ctx.xOperand().rOperand() != null) {
            aType = 2;
            v0 = this.regIndex(ctx.xOperand().rOperand().REG_R().getText());
        } else {
            throw new IllegalStateException("NEG: xOperand is neither rOperand nor fOperand");
        }
        this.out.add(this.encType0(Opcode.NEGATE.code, aType, 0, 0, 0, v0, 0, 0, 0));
        return null;
    }

    public Void visitArithmeticModes(Opcode opc, CPUSim64v2Parser.ArithmeticModesContext ctx) {
        boolean nC;
        int a = 0;
        int b = 0;
        int c = 0;
        int d = 0;
        int v0 = 0;
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        long k = 0L;
        int nA = ctx.aOperand() == null ? 0 : ctx.aOperand().size();
        int nF = ctx.fOperand() == null ? 0 : ctx.fOperand().size();
        boolean nR = ctx.rOperand() != null;
        boolean nX = ctx.xOperand() != null;
        boolean nY = ctx.yOperand() != null;
        boolean bl = nC = ctx.cLiteral() != null;
        if (nA == 1 && nR && nF == 0 && !nX && !nY && !nC) {
            a = 2;
            v0 = this.aIndexFromToken(ctx.aOperand((int)0).start);
            b = 2;
            v1 = this.regIndex(ctx.rOperand().getStart().getText());
            this.out.add(this.encType0(opc.code, a, b, c, d, v0, v1, v2, v3));
        } else if (nF == 1 && nX) {
            a = 3;
            v0 = this.fpIndex(ctx.fOperand(0).getStart().getText());
            if (ctx.xOperand().fOperand() != null) {
                b = 3;
                v1 = this.fpIndex(ctx.xOperand().fOperand().getStart().getText());
            } else {
                b = 2;
                v1 = this.regIndex(ctx.xOperand().rOperand().getStart().getText());
            }
            this.out.add(this.encType0(opc.code, a, b, c, d, v0, v1, v2, v3));
        } else if (nY && nC) {
            boolean yIsFp = ctx.yOperand().fOperand() != null;
            a = yIsFp ? 3 : 2;
            v0 = yIsFp ? this.fpIndex(ctx.yOperand().fOperand().getStart().getText()) : this.aIndexFromToken(ctx.yOperand().aOperand().start);
            k = this.parseIntLike(ctx.cLiteral().getText());
            this.out.add(this.encType2RC2(opc.code, a, v0, k));
        } else if (nA == 2 && nR && !nC && nF <= 1 && !nX) {
            a = 2;
            v0 = this.aIndexFromToken(ctx.aOperand((int)0).start);
            b = 2;
            v1 = this.aIndexFromToken(ctx.aOperand((int)1).start);
            c = 2;
            v2 = this.regIndex(ctx.rOperand().getStart().getText());
            this.out.add(this.encType0(opc.code, a, b, c, d, v0, v1, v2, v3));
        } else if (nF == 2 && nX) {
            a = 3;
            v0 = this.fpIndex(ctx.fOperand(0).getStart().getText());
            b = 3;
            v1 = this.fpIndex(ctx.fOperand(1).getStart().getText());
            if (ctx.xOperand().fOperand() != null) {
                c = 3;
                v2 = this.fpIndex(ctx.xOperand().fOperand().getStart().getText());
            } else {
                c = 2;
                v2 = this.regIndex(ctx.xOperand().rOperand().getStart().getText());
            }
            this.out.add(this.encType0(opc.code, a, b, c, d, v0, v1, v2, v3));
        } else if (nA == 2 && nC && nF == 0 && !nX) {
            a = 2;
            v0 = this.aIndexFromToken(ctx.aOperand((int)0).start);
            b = 2;
            v1 = this.aIndexFromToken(ctx.aOperand((int)1).start);
            v2 = (int)this.parseIntLike(ctx.cLiteral().getText());
            this.out.add(this.encType3ZZC3(opc.code, a, v0, b, v1, v2));
        } else if (nF == 2 && nC && !nX) {
            a = 3;
            v0 = this.fpIndex(ctx.fOperand(0).getStart().getText());
            b = 3;
            v1 = this.fpIndex(ctx.fOperand(1).getStart().getText());
            v2 = (int)this.parseIntLike(ctx.cLiteral().getText());
            this.out.add(this.encType3ZZC3(opc.code, a, v0, b, v1, v2));
        } else {
            throw new AssemblerException("Unhandled " + opc.name() + " form");
        }
        return null;
    }

    @Override
    public Void visitInstrADD(CPUSim64v2Parser.InstrADDContext ctx) {
        this.visitArithmeticModes(Opcode.ADD, ctx.arithmeticModes());
        return null;
    }

    @Override
    public Void visitInstrSUB(CPUSim64v2Parser.InstrSUBContext ctx) {
        this.visitArithmeticModes(Opcode.SUBTRACT, ctx.arithmeticModes());
        return null;
    }

    @Override
    public Void visitInstrMULT(CPUSim64v2Parser.InstrMULTContext ctx) {
        this.visitArithmeticModes(Opcode.MULTIPLY, ctx.arithmeticModes());
        return null;
    }

    @Override
    public Void visitInstrDIV(CPUSim64v2Parser.InstrDIVContext ctx) {
        boolean nC;
        int a = 0;
        int b = 0;
        int c = 0;
        int d = 0;
        int v0 = 0;
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        int nR = ctx.rOperand() == null ? 0 : ctx.rOperand().size();
        boolean bl = nC = ctx.cLiteral() != null;
        if (nR == 4 && !nC) {
            a = 2;
            v0 = this.regIndex(ctx.rOperand(0).getStart().getText());
            b = 2;
            v1 = this.regIndex(ctx.rOperand(1).getStart().getText());
            c = 2;
            v2 = this.regIndex(ctx.rOperand(2).getStart().getText());
            d = 2;
            v3 = this.regIndex(ctx.rOperand(3).getStart().getText());
            this.out.add(this.encType0(Opcode.DIVIDE.code, a, b, c, d, v0, v1, v2, v3));
        } else if (nR == 3 && nC) {
            a = 2;
            v0 = this.regIndex(ctx.rOperand(0).getStart().getText());
            b = 2;
            v1 = this.regIndex(ctx.rOperand(1).getStart().getText());
            c = 2;
            v2 = this.regIndex(ctx.rOperand(2).getStart().getText());
            d = 1;
            v3 = (int)this.parseIntLike(ctx.cLiteral().getText());
            this.out.add(this.encType0(Opcode.DIVIDE.code, a, b, c, d, v0, v1, v2, v3));
        } else {
            this.visitArithmeticModes(Opcode.DIVIDE, ctx.arithmeticModes());
        }
        return null;
    }

    @Override
    public Void visitInstrRECIP(CPUSim64v2Parser.InstrRECIPContext ctx) {
        int v0 = this.fpIndex(ctx.fOperand().REG_F().getText());
        this.out.add(this.encType0(Opcode.RECIP.code, 3, 0, 0, 0, v0, 0, 0, 0));
        return null;
    }

    @Override
    public Void visitInstrCOMPL(CPUSim64v2Parser.InstrCOMPLContext ctx) {
        int v0 = this.regIndex(ctx.rOperand().REG_R().getText());
        this.out.add(this.encType0(Opcode.COMPL.code, 2, 0, 0, 0, v0, 0, 0, 0));
        return null;
    }

    public Void visitLogicModes(Opcode opc, CPUSim64v2Parser.LogicModesContext ctx) {
        int a = 2;
        int v0 = this.regIndex(ctx.rOperand(0).REG_R().getText());
        int c = 0;
        int v2 = 0;
        if (ctx.rOperand().size() == 2 && ctx.cLiteral() == null) {
            int b = 2;
            int v1 = this.regIndex(ctx.rOperand(1).REG_R().getText());
            this.out.add(this.encType0(opc.code, a, b, c, 0, v0, v1, v2, 0));
        } else if (ctx.rOperand().size() == 1 && ctx.cLiteral() != null) {
            boolean b = true;
            long k = this.parseIntLike(ctx.cLiteral().getText());
            this.out.add(this.encType2RC2(opc.code, a, v0, k));
        } else if (ctx.rOperand().size() == 3 && ctx.cLiteral() == null) {
            int b = 2;
            int v1 = this.regIndex(ctx.rOperand(1).REG_R().getText());
            c = 2;
            v2 = this.regIndex(ctx.rOperand(2).REG_R().getText());
            this.out.add(this.encType0(opc.code, a, b, c, 0, v0, v1, v2, 0));
        } else {
            int b = 2;
            int v1 = this.regIndex(ctx.rOperand(1).REG_R().getText());
            v2 = (int)this.parseIntLike(ctx.cLiteral().getText());
            this.out.add(this.encType3ZZC3(opc.code, a, v0, b, v1, v2));
        }
        return null;
    }

    @Override
    public Void visitInstrAND(CPUSim64v2Parser.InstrANDContext ctx) {
        this.visitLogicModes(Opcode.AND, ctx.logicModes());
        return null;
    }

    @Override
    public Void visitInstrOR(CPUSim64v2Parser.InstrORContext ctx) {
        this.visitLogicModes(Opcode.OR, ctx.logicModes());
        return null;
    }

    @Override
    public Void visitInstrXOR(CPUSim64v2Parser.InstrXORContext ctx) {
        this.visitLogicModes(Opcode.XOR, ctx.logicModes());
        return null;
    }

    @Override
    public Void visitInstrTEST(CPUSim64v2Parser.InstrTESTContext ctx) {
        int a = 0;
        int v0 = 0;
        CPUSim64v2Parser.XOperandContext x = ctx.xOperand();
        if (x.fOperand() != null) {
            a = 3;
            v0 = this.fpIndex(x.fOperand().REG_F().getText());
        } else if (x.rOperand() != null) {
            a = 2;
            v0 = this.regIndex(x.rOperand().REG_R().getText());
        }
        this.out.add(this.encType0(Opcode.TEST.code, a, 0, 0, 0, v0, 0, 0, 0));
        return null;
    }

    @Override
    public Void visitInstrCMP(CPUSim64v2Parser.InstrCMPContext ctx) {
        if (ctx.aOperand(0) != null && ctx.aOperand(1) != null) {
            int a = 2;
            int v0 = this.aIndexFromToken(ctx.aOperand((int)0).start);
            int b = 2;
            int v1 = this.aIndexFromToken(ctx.aOperand((int)1).start);
            this.out.add(this.encType0(Opcode.CMP.code, a, b, 0, 0, v0, v1, 0, 0));
        } else if (ctx.aOperand() != null && ctx.cLiteral() != null) {
            if (ctx.rightC != null) {
                int a = 2;
                int v0 = this.aIndexFromToken(ctx.aOperand((int)0).start);
                long k = this.parseIntLike(ctx.cLiteral().getText());
                this.out.add(this.encType2RC2(Opcode.CMP.code, a, v0, k));
            } else {
                int a = 1;
                int v0 = (int)this.parseIntLike(ctx.cLiteral().getText());
                int b = 2;
                int v1 = this.aIndexFromToken(ctx.aOperand((int)0).start);
                this.out.add(this.encType0(Opcode.CMP.code, a, b, 0, 0, v0, v1, 0, 0));
            }
        } else {
            int a = 3;
            int v0 = this.fpIndex(ctx.fOperand(0).REG_F().getText());
            int b = 3;
            int v1 = this.fpIndex(ctx.fOperand(1).REG_F().getText());
            this.out.add(this.encType0(Opcode.CMP.code, a, b, 0, 0, v0, v1, 0, 0));
        }
        return null;
    }

    @Override
    public Void visitInstrLSHIFT(CPUSim64v2Parser.InstrLSHIFTContext ctx) {
        this.visitLogicModes(Opcode.LSHIFT, ctx.logicModes());
        return null;
    }

    @Override
    public Void visitInstrRSHIFT(CPUSim64v2Parser.InstrRSHIFTContext ctx) {
        this.visitLogicModes(Opcode.RSHIFT, ctx.logicModes());
        return null;
    }

    @Override
    public Void visitInstrARSHIFT(CPUSim64v2Parser.InstrARSHIFTContext ctx) {
        this.visitLogicModes(Opcode.ARSHIFT, ctx.logicModes());
        return null;
    }

    @Override
    public Void visitInstrLROTATE(CPUSim64v2Parser.InstrLROTATEContext ctx) {
        this.visitLogicModes(Opcode.LROTATE, ctx.logicModes());
        return null;
    }

    @Override
    public Void visitInstrRROTATE(CPUSim64v2Parser.InstrRROTATEContext ctx) {
        this.visitLogicModes(Opcode.RROTATE, ctx.logicModes());
        return null;
    }

    @Override
    public Void visitInstrPACK(CPUSim64v2Parser.InstrPACKContext ctx) {
        int a = 2;
        int v0 = this.regIndex(ctx.rOperand(0).REG_R().getText());
        int b = 0;
        int c = 0;
        int d = 0;
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        if (ctx.rOperand().size() >= 2) {
            b = 2;
            v1 = this.regIndex(ctx.rOperand(1).REG_R().getText());
        }
        if (ctx.rOperand().size() >= 3) {
            c = 2;
            v2 = this.regIndex(ctx.rOperand(2).REG_R().getText());
        }
        if (ctx.rOperand().size() >= 4) {
            d = 2;
            v3 = this.regIndex(ctx.rOperand(3).REG_R().getText());
        }
        this.out.add(this.encType0(Opcode.PACK.code, a, b, c, d, v0, v1, v2, v3));
        return null;
    }

    @Override
    public Void visitInstrPACK64(CPUSim64v2Parser.InstrPACK64Context ctx) {
        int a = 2;
        int v0 = this.regIndex(ctx.rOperand(0).REG_R().getText());
        int b = 0;
        int c = 0;
        int d = 0;
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        if (ctx.rOperand().size() >= 2) {
            b = 2;
            v1 = this.regIndex(ctx.rOperand(1).REG_R().getText());
        }
        if (ctx.rOperand().size() >= 3) {
            c = 2;
            v2 = this.regIndex(ctx.rOperand(2).REG_R().getText());
        }
        if (ctx.rOperand().size() >= 4) {
            d = 2;
            v3 = this.regIndex(ctx.rOperand(3).REG_R().getText());
        }
        this.out.add(this.encType0(Opcode.PACK64.code, a, b, c, d, v0, v1, v2, v3));
        return null;
    }

    @Override
    public Void visitInstrUNPACK(CPUSim64v2Parser.InstrUNPACKContext ctx) {
        int a = 2;
        int v0 = this.regIndex(ctx.rOperand(0).REG_R().getText());
        int b = 0;
        int c = 0;
        int d = 0;
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        if (ctx.rOperand().size() >= 2) {
            b = 2;
            v1 = this.regIndex(ctx.rOperand(1).REG_R().getText());
        }
        if (ctx.rOperand().size() >= 3) {
            c = 2;
            v2 = this.regIndex(ctx.rOperand(2).REG_R().getText());
        }
        if (ctx.rOperand().size() >= 4) {
            d = 2;
            v3 = this.regIndex(ctx.rOperand(3).REG_R().getText());
        }
        this.out.add(this.encType0(Opcode.UNPACK.code, a, b, c, d, v0, v1, v2, v3));
        return null;
    }

    @Override
    public Void visitInstrUNPACK64(CPUSim64v2Parser.InstrUNPACK64Context ctx) {
        int a = 2;
        int v0 = this.regIndex(ctx.rOperand(0).REG_R().getText());
        int b = 0;
        int c = 0;
        int d = 0;
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        if (ctx.rOperand().size() >= 2) {
            b = 2;
            v1 = this.regIndex(ctx.rOperand(1).REG_R().getText());
        }
        if (ctx.rOperand().size() >= 3) {
            c = 2;
            v2 = this.regIndex(ctx.rOperand(2).REG_R().getText());
        }
        if (ctx.rOperand().size() >= 4) {
            d = 2;
            v3 = this.regIndex(ctx.rOperand(3).REG_R().getText());
        }
        this.out.add(this.encType0(Opcode.UNPACK64.code, a, b, c, d, v0, v1, v2, v3));
        return null;
    }

    @Override
    public Void visitInstrCAS(CPUSim64v2Parser.InstrCASContext ctx) {
        boolean a = false;
        boolean b = false;
        boolean c = false;
        boolean d = false;
        boolean v0 = false;
        boolean v1 = false;
        boolean v2 = false;
        boolean v3 = false;
        Pair<Integer, Long> oldVal = this.parseOOperand(ctx.oOperand(0));
        Pair<Integer, Long> newVal = this.parseOOperand(ctx.oOperand(1));
        Pair<Pair<Integer, Long>, Pair<Integer, Long>> memRef = this.parseMemRef(ctx.memRef());
        this.out.add(this.encType0(Opcode.CAS.code, oldVal.getLeft(), newVal.getLeft(), memRef.getLeft().getLeft(), memRef.getRight().getLeft(), oldVal.getRight().intValue(), newVal.getRight().intValue(), memRef.getLeft().getRight().intValue(), memRef.getRight().getRight().intValue()));
        return null;
    }

    @Override
    public Void visitInstrENDIAN(CPUSim64v2Parser.InstrENDIANContext ctx) {
        int a = 0;
        int b = 0;
        int v0 = 0;
        int v1 = 0;
        if (ctx.children.size() < 2) {
            throw new AssemblerException("ENDIAN missing operands");
        }
        if (ctx.getChild(1) instanceof CPUSim64v2Parser.ROperandContext && ctx.getChild(3) instanceof CPUSim64v2Parser.ROperandContext) {
            a = 2;
            b = 2;
            v0 = this.regIndex(ctx.rOperand(0).REG_R().getText());
            v1 = this.regIndex(ctx.rOperand(1).REG_R().getText());
        } else if (ctx.getChild(1) instanceof CPUSim64v2Parser.ZPortContext && ctx.getChild(3) instanceof CPUSim64v2Parser.ZPortContext) {
            a = 1;
            b = 1;
            v0 = (int)this.parseIntLike(ctx.zPort(0).getText());
            v1 = (int)this.parseIntLike(ctx.zPort(1).getText());
        } else if (ctx.getChild(1) instanceof CPUSim64v2Parser.ROperandContext && ctx.getChild(3) instanceof CPUSim64v2Parser.ZPortContext) {
            a = 2;
            b = 1;
            v0 = this.regIndex(ctx.rOperand(0).REG_R().getText());
            v1 = (int)this.parseIntLike(ctx.zPort(0).getText());
        } else if (ctx.getChild(1) instanceof CPUSim64v2Parser.ZPortContext && ctx.getChild(3) instanceof CPUSim64v2Parser.ROperandContext) {
            a = 1;
            b = 2;
            v0 = (int)this.parseIntLike(ctx.zPort(0).getText());
            v1 = this.regIndex(ctx.rOperand(0).REG_R().getText());
        } else {
            throw new AssemblerException("ENDIAN invalid operand types");
        }
        this.out.add(this.encType0(Opcode.ENDIAN.code, a, b, 0, 0, v0, v1, 0, 0));
        return null;
    }

    @Override
    public Void visitInstrIN(CPUSim64v2Parser.InstrINContext ctx) {
        boolean isFP;
        int a = 0;
        int b = 0;
        int c = 0;
        int d = 0;
        int v0 = 0;
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        boolean bl = isFP = ctx.xOperand().fOperand() != null;
        if (isFP) {
            a = 3;
            v0 = this.fpIndex(ctx.xOperand().fOperand().REG_F().getText());
        } else {
            a = 2;
            v0 = this.regIndex(ctx.xOperand().rOperand().REG_R().getText());
        }
        if (ctx.children.size() < 3) {
            throw new AssemblerException("IN missing operands");
        }
        if (ctx.getChild(3) instanceof CPUSim64v2Parser.ROperandContext && ctx.getChild(5) instanceof CPUSim64v2Parser.ROperandContext) {
            b = 2;
            c = 2;
            v1 = this.regIndex(ctx.rOperand(0).REG_R().getText());
            v2 = this.regIndex(ctx.rOperand(1).REG_R().getText());
        } else if (ctx.getChild(3) instanceof CPUSim64v2Parser.ZPortContext && ctx.getChild(5) instanceof CPUSim64v2Parser.ZPortContext) {
            b = 1;
            c = 1;
            v1 = (int)this.parseIntLike(ctx.zPort(0).getText());
            v2 = (int)this.parseIntLike(ctx.zPort(1).getText());
        } else if (ctx.getChild(3) instanceof CPUSim64v2Parser.ROperandContext && ctx.getChild(5) instanceof CPUSim64v2Parser.ZPortContext) {
            b = 2;
            c = 1;
            v1 = this.regIndex(ctx.rOperand(0).REG_R().getText());
            v2 = (int)this.parseIntLike(ctx.zPort(0).getText());
        } else if (ctx.getChild(3) instanceof CPUSim64v2Parser.ZPortContext && ctx.getChild(5) instanceof CPUSim64v2Parser.ROperandContext) {
            b = 1;
            c = 2;
            v1 = (int)this.parseIntLike(ctx.zPort(0).getText());
            v2 = this.regIndex(ctx.rOperand(0).REG_R().getText());
        } else {
            throw new AssemblerException("IN invalid operand types");
        }
        this.out.add(this.encType0(Opcode.IN.code, a, b, c, d, v0, v1, v2, v3));
        return null;
    }

    @Override
    public Void visitInstrOUT(CPUSim64v2Parser.InstrOUTContext ctx) {
        boolean isREG;
        int a = 0;
        int b = 0;
        int c = 0;
        int d = 0;
        int v0 = 0;
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        boolean isFP = ctx.qOperand().fOperand() != null;
        boolean bl = isREG = ctx.qOperand().aOperand() != null;
        if (isFP) {
            a = 3;
            v0 = this.fpIndex(ctx.qOperand().fOperand().REG_F().getText());
        } else if (isREG) {
            a = 2;
            v0 = this.aIndexFromToken(ctx.qOperand().aOperand().start);
        } else {
            a = 1;
            v0 = (int)this.parseIntLike(ctx.qOperand().cLiteral().getText());
        }
        if (ctx.children.size() < 3) {
            throw new AssemblerException("IN missing operands");
        }
        if (ctx.getChild(3) instanceof CPUSim64v2Parser.ROperandContext && ctx.getChild(5) instanceof CPUSim64v2Parser.ROperandContext) {
            b = 2;
            c = 2;
            v1 = this.regIndex(ctx.rOperand(0).REG_R().getText());
            v2 = this.regIndex(ctx.rOperand(1).REG_R().getText());
        } else if (ctx.getChild(3) instanceof CPUSim64v2Parser.ZPortContext && ctx.getChild(5) instanceof CPUSim64v2Parser.ZPortContext) {
            b = 1;
            c = 1;
            v1 = (int)this.parseIntLike(ctx.zPort(0).getText());
            v2 = (int)this.parseIntLike(ctx.zPort(1).getText());
        } else if (ctx.getChild(3) instanceof CPUSim64v2Parser.ROperandContext && ctx.getChild(5) instanceof CPUSim64v2Parser.ZPortContext) {
            b = 2;
            c = 1;
            v1 = this.regIndex(ctx.rOperand(0).REG_R().getText());
            v2 = (int)this.parseIntLike(ctx.zPort(0).getText());
        } else if (ctx.getChild(3) instanceof CPUSim64v2Parser.ZPortContext && ctx.getChild(5) instanceof CPUSim64v2Parser.ROperandContext) {
            b = 1;
            c = 2;
            v1 = (int)this.parseIntLike(ctx.zPort(0).getText());
            v2 = this.regIndex(ctx.rOperand(0).REG_R().getText());
        } else {
            throw new AssemblerException("OUT invalid operand types");
        }
        this.out.add(this.encType0(Opcode.OUT.code, a, b, c, d, v0, v1, v2, v3));
        return null;
    }

    @Override
    public Void visitInstrSAVE(CPUSim64v2Parser.InstrSAVEContext ctx) {
        if (ctx.xOperand() != null) {
            int v1;
            int b;
            int v0;
            boolean isFp = ctx.xOperand(0).fOperand() != null;
            int a = isFp ? 3 : 2;
            int n = v0 = isFp ? this.fpIndex(ctx.xOperand(0).fOperand().REG_F().getText()) : this.regIndex(ctx.xOperand(0).rOperand().REG_R().getText());
            if (ctx.xOperand().size() >= 2) {
                if (isFp != (ctx.xOperand(1).fOperand() != null)) {
                    throw new AssemblerException("SAVE operands must be the same type");
                }
                b = isFp ? 3 : 2;
                v1 = isFp ? this.fpIndex(ctx.xOperand(1).fOperand().REG_F().getText()) : this.regIndex(ctx.xOperand(1).rOperand().REG_R().getText());
            } else {
                b = a;
                int n2 = v1 = isFp ? 31 : 28;
            }
            if (v0 > v1) {
                throw new AssemblerException("SAVE first operand must be less than second");
            }
            this.out.add(this.encType0(Opcode.SAVE.code, a, b, 0, 0, v0, v1, 0, 0));
            return null;
        }
        throw new AssemblerException("SAVE invalid operand types");
    }

    @Override
    public Void visitInstrRESTORE(CPUSim64v2Parser.InstrRESTOREContext ctx) {
        if (ctx.xOperand() != null) {
            int v1;
            int b;
            int v0;
            boolean isFp = ctx.xOperand(0).fOperand() != null;
            int a = isFp ? 3 : 2;
            int n = v0 = isFp ? this.fpIndex(ctx.xOperand(0).fOperand().REG_F().getText()) : this.regIndex(ctx.xOperand(0).rOperand().REG_R().getText());
            if (ctx.xOperand().size() >= 2) {
                if (isFp != (ctx.xOperand(1).fOperand() != null)) {
                    throw new AssemblerException("RESTORE operands must be the same type");
                }
                b = isFp ? 3 : 2;
                v1 = isFp ? this.fpIndex(ctx.xOperand(1).fOperand().REG_F().getText()) : this.regIndex(ctx.xOperand(1).rOperand().REG_R().getText());
            } else {
                b = a;
                int n2 = v1 = isFp ? 31 : 28;
            }
            if (v0 > v1) {
                throw new AssemblerException("RESTORE first operand must be less than second");
            }
            this.out.add(this.encType0(Opcode.RESTORE.code, a, b, 0, 0, v0, v1, 0, 0));
            return null;
        }
        throw new AssemblerException("RESTORE invalid operand types");
    }

    @Override
    public Void visitInstrREADONLY(CPUSim64v2Parser.InstrREADONLYContext ctx) {
        if (ctx.cLiteral() == null) {
            throw new AssemblerException("READONLY invalid operand types");
        }
        long k = this.parseIntLike(ctx.cLiteral().getText());
        this.out.add(this.encType1C1(Opcode.READONLY.code, k));
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Void visitData_Directive(CPUSim64v2Parser.Data_DirectiveContext ddctx) {
        CPUSim64v2Parser.DataDirectiveContext ctx = ddctx.dataDirective();
        if (ctx.DCI() != null) {
            if (ctx.INTLIT() != null) {
                this.out.add(this.parseIntLike(ctx.INTLIT().getText()));
                return null;
            } else {
                if (ctx.HEXLIT() == null) throw new IllegalStateException("Invalid DCI literal");
                this.out.add(this.parseIntLike(ctx.HEXLIT().getText()));
            }
            return null;
        } else if (ctx.DCF() != null) {
            if (ctx.FLOATLIT() == null) throw new IllegalStateException("Invalid DCF literal");
            this.out.add(Double.doubleToRawLongBits(Double.parseDouble(ctx.FLOATLIT().getText())));
            return null;
        } else if (ctx.DCA() != null) {
            long b = 0L;
            if (ctx.INTLIT() != null) {
                b = this.parseIntLike(ctx.INTLIT().getText());
            } else if (ctx.HEXLIT() != null) {
                b = this.parseIntLike(ctx.HEXLIT().getText());
            }
            if (b == 0L) return null;
            this.out.add(b);
            int i = 0;
            while ((long)i < b) {
                this.out.add(0L);
                ++i;
            }
            return null;
        } else if (ctx.DCB() != null) {
            if (ctx.byteList() == null) throw new IllegalStateException("Invalid DCB directive");
            this.out.add(Long.valueOf(ctx.byteList().bLiteral().size()));
            long buffer = 0L;
            int index = 7;
            for (CPUSim64v2Parser.BLiteralContext bctx : ctx.byteList().bLiteral()) {
                long b = 0L;
                if (bctx.INTLIT() != null) {
                    b = this.parseIntLike(bctx.INTLIT().getText());
                } else if (bctx.HEXLIT() != null) {
                    b = this.parseIntLike(bctx.HEXLIT().getText());
                } else {
                    if (bctx.CHARLIT() == null) throw new IllegalStateException("Invalid DCB byte literal");
                    String s = bctx.CHARLIT().getText();
                    b = this.parseIntLike(bctx.HEXLIT().getText());
                }
                buffer |= (b & 0xFFL) << index * 8;
                if (--index >= 0) continue;
                this.out.add(buffer);
                buffer = 0L;
                index = 7;
            }
            if (index == 7) return null;
            this.out.add(buffer);
            return null;
        } else if (ctx.DCC() != null) {
            if (ctx.byteList() == null) throw new IllegalStateException("Invalid DCC directive");
            this.out.add(Long.valueOf(ctx.byteList().bLiteral().size()));
            long buffer = 0L;
            int index = 3;
            for (CPUSim64v2Parser.BLiteralContext bctx : ctx.byteList().bLiteral()) {
                long b = 0L;
                if (bctx.INTLIT() != null) {
                    b = this.parseIntLike(bctx.INTLIT().getText());
                } else if (bctx.HEXLIT() != null) {
                    b = this.parseIntLike(bctx.HEXLIT().getText());
                } else {
                    if (bctx.CHARLIT() == null) throw new IllegalStateException("Invalid DCC char literal");
                    String s = bctx.CHARLIT().getText();
                    b = Utils.parseCharLiteral(s);
                }
                buffer |= (b & 0xFFFFL) << index * 16;
                if (--index >= 0) continue;
                this.out.add(buffer);
                buffer = 0L;
                index = 3;
            }
            if (index == 3) return null;
            this.out.add(buffer);
            return null;
        } else if (ctx.DCW() != null) {
            if (ctx.intList() != null) {
                this.out.add(Long.valueOf(ctx.intList().kLiteral().size()));
                for (CPUSim64v2Parser.KLiteralContext kctx : ctx.intList().kLiteral()) {
                    long k = 0L;
                    if (kctx.INTLIT() != null) {
                        k = this.parseIntLike(kctx.INTLIT().getText());
                    } else {
                        if (kctx.HEXLIT() == null) throw new IllegalStateException("Invalid DCW literal");
                        k = this.parseIntLike(kctx.HEXLIT().getText());
                    }
                    this.out.add(k);
                }
                return null;
            } else if (ctx.floatList() != null) {
                this.out.add(Long.valueOf(ctx.floatList().FLOATLIT().size()));
                for (TerminalNode fctx : ctx.floatList().FLOATLIT()) {
                    this.out.add(Double.doubleToRawLongBits(Double.parseDouble(fctx.getText())));
                }
                return null;
            } else {
                if (ctx.charList() == null) throw new IllegalStateException("Invalid DCW directive");
                this.out.add(Long.valueOf(ctx.charList().CHARLIT().size()));
                for (TerminalNode kctx : ctx.charList().CHARLIT()) {
                    String s = kctx.getText();
                    long k = Utils.parseCharLiteral(s);
                    this.out.add(k);
                }
            }
            return null;
        } else {
            if (ctx.DCS() == null) return null;
            if (ctx.STRINGLIT() == null) {
                throw new IllegalStateException("Invalid DCS directive");
            }
            String s = ctx.STRINGLIT().getText();
            if (s == null || s.length() < 2) throw new IllegalStateException("Invalid DCS directive");
            s = s.substring(1, s.length() - 1);
            byte[] utf8 = Utils.parseStringLiteral(s);
            this.out.add(Long.valueOf(utf8.length));
            long buffer = 0L;
            int index = 7;
            for (byte c : utf8) {
                buffer |= ((long)c & 0xFFL) << index * 8;
                if (--index >= 0) continue;
                this.out.add(buffer);
                buffer = 0L;
                index = 7;
            }
            if (index == 7) return null;
            this.out.add(buffer);
        }
        return null;
    }

    @Override
    public Void visitORG_Directive(CPUSim64v2Parser.ORG_DirectiveContext ctx) {
        long currentAddress = 0L;
        if (ctx.INTLIT() != null) {
            currentAddress = Long.parseLong(ctx.INTLIT().getText());
        } else if (ctx.HEXLIT() != null) {
            currentAddress = Long.parseLong(ctx.HEXLIT().getText().substring(2), 16);
        } else {
            throw new AssemblerException(this.getLocation() + ": Error: Missing integer literal for .ORG directive");
        }
        currentAddress = Math.max((long)this.out.size(), currentAddress);
        int i = this.out.size();
        while ((long)i < currentAddress) {
            this.out.add(0L);
            ++i;
        }
        return null;
    }

    @Override
    public Void visitLINE_Directive(CPUSim64v2Parser.LINE_DirectiveContext ctx) {
        this.filename = ctx.FILENAMELIT().getText();
        this.lineNum = ctx.INTLIT() != null ? Integer.parseInt(ctx.INTLIT().getText()) : 1;
        this.pauseLineIncrement = false;
        return null;
    }

    @Override
    public Void visitLINE_BEGIN_Directive(CPUSim64v2Parser.LINE_BEGIN_DirectiveContext ctx) {
        this.filename = ctx.FILENAMELIT().getText();
        this.lineNum = ctx.INTLIT() != null ? Integer.parseInt(ctx.INTLIT().getText()) : 1;
        this.pauseLineIncrement = true;
        return null;
    }

    @Override
    public Void visitLINE_END_Directive(CPUSim64v2Parser.LINE_END_DirectiveContext ctx) {
        this.pauseLineIncrement = false;
        return null;
    }

    @Override
    public Void visitBLOCK_BEGIN_Directive(CPUSim64v2Parser.BLOCK_BEGIN_DirectiveContext ctx) {
        String blockname = null;
        if (ctx.IDENT() != null) {
            blockname = ctx.IDENT().getText();
            if (blockname.contains("$")) {
                throw new AssemblerException("Blocknames can not contain $: " + blockname);
            }
        } else if (ctx.BLOCK_IDENT() != null) {
            blockname = ctx.BLOCK_IDENT().getText();
        }
        if (blockname == null) {
            throw new AssemblerException(".block directive must have an argument@");
        }
        if (blockname.contains("{}") || blockname.contains("%d") || blockname.contains("%x")) {
            blockname = String.format(blockname.replace("{}", "%04x"), ++this.blockCount);
        }
        this.blockNames.push(blockname);
        return null;
    }

    @Override
    public Void visitBLOCK_END_Directive(CPUSim64v2Parser.BLOCK_END_DirectiveContext ctx) {
        String name = this.blockNames.pop();
        return null;
    }

    public void assemble(String src) {
        CodePointCharStream input = CharStreams.fromString(src);
        CPUSim64v2Lexer lex = new CPUSim64v2Lexer(input);
        CollectingErrorListener lexerListener = new CollectingErrorListener(this.errors, null);
        lex.removeErrorListeners();
        lex.addErrorListener(lexerListener);
        CommonTokenStream toks = new CommonTokenStream(lex);
        CPUSim64v2Parser parser = new CPUSim64v2Parser(toks);
        CollectingErrorListener parserListener = new CollectingErrorListener(this.errors, null);
        parser.removeErrorListeners();
        parser.addErrorListener(parserListener);
        CPUSim64v2Parser.ProgramContext tree = parser.program();
        this.visit(tree);
    }

    public class AssemblerException
    extends RuntimeException {
        public AssemblerException(String msg) {
            super("[" + AssemblerVisitor.this.getLocation() + "] " + msg);
        }
    }
}

