/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64v2;

import cloud.lesh.CPUSim64v2.HasLocation;
import java.util.List;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;

public final class CollectingErrorListener
extends BaseErrorListener {
    private List<String> errors;
    HasLocation locator;

    public CollectingErrorListener(List<String> errors, HasLocation locator) {
        this.errors = errors;
        this.locator = locator;
    }

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        String offendingText = "";
        if (e instanceof LexerNoViableAltException) {
            LexerNoViableAltException lexNoAlt = (LexerNoViableAltException)e;
            CharStream cs = ((Lexer)recognizer).getInputStream();
            int start = lexNoAlt.getStartIndex();
            int stop = Math.min(start, cs.size() - 1);
            offendingText = cs.getText(Interval.of(start, stop));
        } else if (offendingSymbol instanceof Token) {
            Token tok = (Token)offendingSymbol;
            offendingText = tok.getText();
        }
        String formatted = this.locator == null ? String.format("Preprocessed line %d:%d %s%s", line, charPositionInLine, msg, offendingText.isEmpty() ? "" : " (offending: " + CollectingErrorListener.escape(offendingText) + ")") : String.format("%s:%d %s%s", this.locator.getLocation(), charPositionInLine, msg, offendingText.isEmpty() ? "" : " (offending: " + CollectingErrorListener.escape(offendingText) + ")");
        this.errors.add(formatted);
    }

    private static String escape(String s) {
        return s.replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }
}

