/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64v2;

import cloud.lesh.CPUSim64v2.PortHandler;
import cloud.lesh.CPUSim64v2.Simulator;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class FilePortHandler
extends PortHandler {
    private FileOutputStream os;
    private FileInputStream fis;
    private InputStreamReader is;
    private String filespec;

    public FilePortHandler(Simulator cpu, int mode, String filespec) throws Simulator.CPUException {
        super(cpu);
        this.filespec = filespec;
        try {
            switch (mode) {
                case 0: {
                    this.fis = new FileInputStream(filespec);
                    this.is = new InputStreamReader((InputStream)this.fis, StandardCharsets.UTF_8);
                    break;
                }
                case 1: {
                    this.os = new FileOutputStream(filespec);
                    break;
                }
                case 2: {
                    this.os = new FileOutputStream(filespec, true);
                    break;
                }
                default: {
                    Simulator simulator = cpu;
                    Objects.requireNonNull(simulator);
                    throw new Simulator.CPUException(simulator, "Illegal file open mode!");
                }
            }
        }
        catch (Exception e) {
            Simulator simulator = cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "File open error on \"" + filespec + "\" using mode " + mode + "!");
        }
    }

    @Override
    public int read() throws Simulator.CPUException {
        if (this.is == null) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "File \"" + this.filespec + "\" not open for input!");
        }
        try {
            return this.fis.read();
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "Read error on file \"" + this.filespec + "\"!");
        }
    }

    @Override
    public int readChar() throws Simulator.CPUException {
        int codePoint = -1;
        if (this.is == null) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "File \"" + this.filespec + "\" not open for input!");
        }
        try {
            int ch1 = this.is.read();
            if (ch1 != -1) {
                char c1 = (char)ch1;
                if (Character.isHighSurrogate(c1)) {
                    int ch2 = this.is.read();
                    if (ch2 != -1) {
                        char c2 = (char)ch2;
                        if (Character.isLowSurrogate(c2)) {
                            codePoint = Character.toCodePoint(c1, c2);
                        } else {
                            codePoint = c1;
                            this.is.reset();
                        }
                    } else {
                        codePoint = c1;
                    }
                } else {
                    codePoint = c1;
                }
            }
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "Read error on file \"" + this.filespec + "\"!");
        }
        return codePoint;
    }

    @Override
    public void write(byte x) throws Simulator.CPUException {
        if (this.os == null) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "File \"" + this.filespec + "\" not open for output!");
        }
        try {
            this.os.write(x);
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "Write error on file \"" + this.filespec + "\"!");
        }
    }

    @Override
    public void writeChar(int codePoint) throws Simulator.CPUException {
        if (this.os == null) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "File \"" + this.filespec + "\" not open for output!");
        }
        try {
            String s = new String(Character.toChars(codePoint));
            byte[] utf8 = s.getBytes(StandardCharsets.UTF_8);
            this.os.write(utf8);
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "Write error on file \"" + this.filespec + "\"!");
        }
    }

    @Override
    public void flush() throws Simulator.CPUException {
        if (this.os == null) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "File \"" + this.filespec + "\" not open for output!");
        }
        try {
            this.os.flush();
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "Flush error on file \"" + this.filespec + "\"!");
        }
    }

    @Override
    public void close() throws Simulator.CPUException {
        try {
            if (this.is != null) {
                this.is.close();
            }
            if (this.os != null) {
                this.os.close();
            }
            this.is = null;
            this.os = null;
        }
        catch (Exception e) {
            Simulator simulator = this.cpu;
            Objects.requireNonNull(simulator);
            throw new Simulator.CPUException(simulator, "Error closing file \"" + this.filespec + "\"!");
        }
    }
}

