/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64v2;

import cloud.lesh.CPUSim64v2.PreprocessorVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class IncludeLoader
implements PreprocessorVisitor.IncludeLoader {
    private final Path baseDir;

    public IncludeLoader(Path baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public String load(String filename, boolean isSystemPath) {
        String string;
        block12: {
            if (!isSystemPath) {
                try {
                    Path file = this.baseDir.resolve(filename).normalize();
                    return Files.readString(file);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to include local file " + filename, e);
                }
            }
            String resourceName = filename.startsWith("/") ? filename.substring(1) : filename;
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourceName);
            try {
                if (in == null) {
                    throw new IllegalArgumentException("System include not found on classpath: " + filename);
                }
                string = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to read system include " + filename, e);
                }
            }
            in.close();
        }
        return string;
    }
}

