/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64v2;

import cloud.lesh.CPUSim64v2.CPUSim64v2BaseVisitor;
import cloud.lesh.CPUSim64v2.CPUSim64v2Lexer;
import cloud.lesh.CPUSim64v2.CPUSim64v2Parser;
import cloud.lesh.CPUSim64v2.CollectingErrorListener;
import cloud.lesh.CPUSim64v2.HasLocation;
import cloud.lesh.CPUSim64v2.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class LabelVisitor
extends CPUSim64v2BaseVisitor<Void>
implements HasLocation {
    private final StringBuilder out = new StringBuilder();
    private final Map<String, Long> labelMap = new HashMap<String, Long>();
    private final Set<String> definedLabels = new HashSet<String>();
    private final Stack<String> blockNames = new Stack();
    private long currentAddress = 0L;
    private long blockCount = 0L;
    String filename = null;
    int lineNum = 1;
    boolean pauseLineIncrement = false;
    private final Vector<String> errors = new Vector();
    Map<Integer, String> lineMap = new HashMap<Integer, String>();

    @Override
    public String getLocation() {
        return (String)(this.filename == null ? "" : this.filename + ":") + this.lineNum;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public Map<Integer, String> getLineMap() {
        return this.lineMap;
    }

    public Map<String, Long> getLabelMap() {
        return this.labelMap;
    }

    private static Token startToken(ParseTree node) {
        if (node instanceof ParserRuleContext) {
            ParserRuleContext r = (ParserRuleContext)node;
            return r.getStart();
        }
        if (node instanceof TerminalNode) {
            TerminalNode t = (TerminalNode)node;
            return t.getSymbol();
        }
        if (node instanceof ErrorNode) {
            ErrorNode e = (ErrorNode)node;
            return e.getSymbol();
        }
        return null;
    }

    private long parseIntLike(String text) {
        if (text.startsWith("0x") || text.startsWith("0X")) {
            return Long.parseUnsignedLong(text.substring(2), 16);
        }
        if (text.startsWith("-0x") || text.startsWith("-0X")) {
            return -Long.parseUnsignedLong(text.substring(3), 16);
        }
        if (text.charAt(0) == '-' || text.charAt(0) >= '0' && text.charAt(0) <= '9') {
            return Long.parseLong(text);
        }
        throw new IllegalArgumentException("Can't parse integer: " + text);
    }

    private long parseStringLiteral(String s) {
        if (s.length() >= 2 && s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            s = s.substring(1, s.length() - 1);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\\' && i + 1 < s.length()) {
                char next = s.charAt(i + 1);
                switch (next) {
                    case 'n': {
                        sb.append('\n');
                        ++i;
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        ++i;
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        ++i;
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        ++i;
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        ++i;
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        ++i;
                        break;
                    }
                    case '0': {
                        sb.append('\u0000');
                        ++i;
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        Pattern p = Pattern.compile("\\{([0-9A-Fa-f]{1,5})\\}");
                        Matcher m = p.matcher(s.substring(i));
                        if (m.find()) {
                            String hex = m.group(1);
                            int codePoint = Integer.parseInt(hex, 16);
                            return codePoint;
                        }
                        sb.append(s);
                        ++i;
                        break;
                    }
                    default: {
                        sb.append(ch);
                        break;
                    }
                }
                continue;
            }
            sb.append(ch);
        }
        String unescaped = sb.toString();
        if (unescaped.length() != 1) {
            throw new IllegalStateException("CHARLIT must be a single character");
        }
        return unescaped.codePointAt(0);
    }

    @Override
    public Void visitProgram(CPUSim64v2Parser.ProgramContext ctx) {
        for (ParseTree child : ctx.children) {
            this.visit(child);
            Token t = LabelVisitor.startToken(child);
            if (t != null) {
                int line = t.getLine();
                int col = t.getCharPositionInLine();
                this.lineMap.put(line, this.getLocation());
            }
            if (this.pauseLineIncrement) continue;
            ++this.lineNum;
        }
        this.labelMap.putIfAbsent("__CODE_END__", this.currentAddress);
        this.labelMap.putIfAbsent("__DATA__", this.currentAddress);
        this.labelMap.putIfAbsent("__HEAP_START__", this.currentAddress);
        return null;
    }

    private String getScopeName() {
        return String.join((CharSequence)"$", this.blockNames).toUpperCase();
    }

    @Override
    public Void visitLabelDef(CPUSim64v2Parser.LabelDefContext ctx) {
        Object labelName = ctx.IDENT().getText().toUpperCase();
        if (this.definedLabels.contains(labelName)) {
            this.errors.add(this.getLocation() + ": Error: Duplicate label '" + (String)labelName + "'");
        } else {
            if (((String)labelName).charAt(0) == '$') {
                labelName = this.getScopeName() + (String)labelName;
            }
            this.definedLabels.add((String)labelName);
            this.labelMap.put((String)labelName, this.currentAddress);
        }
        return null;
    }

    @Override
    public Void visitInstruction(CPUSim64v2Parser.InstructionContext ctx) {
        ++this.currentAddress;
        this.out.append(LabelVisitor.reflowTokens(ctx) + System.lineSeparator());
        return null;
    }

    @Override
    public Void visitData_Directive(CPUSim64v2Parser.Data_DirectiveContext ctx) {
        if (ctx.dataDirective() != null) {
            if (ctx.dataDirective().DCI() != null) {
                ++this.currentAddress;
            } else if (ctx.dataDirective().DCF() != null) {
                ++this.currentAddress;
            } else if (ctx.dataDirective().DCS() != null) {
                if (ctx.dataDirective().STRINGLIT() == null || ctx.dataDirective().STRINGLIT().getText().length() < 2) {
                    this.errors.add(this.getLocation() + ": Error: Missing string literal for .DCS directive");
                    return null;
                }
                String s = ctx.dataDirective().STRINGLIT().getText();
                s = s.substring(1, s.length() - 1);
                byte[] utf8 = Utils.parseStringLiteral(s);
                this.currentAddress += (long)(1 + (utf8.length + 7) / 8);
            } else if (ctx.dataDirective().DCA() != null) {
                long b = 0L;
                if (ctx.dataDirective().INTLIT() != null) {
                    b = this.parseIntLike(ctx.dataDirective().INTLIT().getText());
                } else if (ctx.dataDirective().HEXLIT() != null) {
                    b = this.parseIntLike(ctx.dataDirective().HEXLIT().getText());
                }
                this.currentAddress += 1L + b;
            } else if (ctx.dataDirective().DCB() != null) {
                this.currentAddress += (long)(1 + (ctx.dataDirective().byteList().bLiteral().size() + 7) / 8);
            } else if (ctx.dataDirective().DCW() != null) {
                int count = 0;
                if (ctx.dataDirective().intList() != null) {
                    count = ctx.dataDirective().intList().kLiteral().size();
                } else if (ctx.dataDirective().floatList() != null) {
                    count = ctx.dataDirective().floatList().FLOATLIT().size();
                } else if (ctx.dataDirective().charList() != null) {
                    count = ctx.dataDirective().charList().CHARLIT().size();
                }
                this.currentAddress += (long)(1 + count);
            }
        }
        this.out.append(LabelVisitor.reflowTokens(ctx) + System.lineSeparator());
        return null;
    }

    @Override
    public Void visitORG_Directive(CPUSim64v2Parser.ORG_DirectiveContext ctx) {
        if (ctx.INTLIT() != null) {
            this.currentAddress = Long.parseLong(ctx.INTLIT().getText());
        } else if (ctx.HEXLIT() != null) {
            this.currentAddress = Long.parseLong(ctx.HEXLIT().getText().substring(2), 16);
        } else {
            this.errors.add(this.getLocation() + ": Error: Missing integer literal for .ORG directive");
        }
        this.currentAddress = Math.max(0L, this.currentAddress);
        this.out.append(LabelVisitor.reflowTokens(ctx) + System.lineSeparator());
        return null;
    }

    @Override
    public Void visitLINE_Directive(CPUSim64v2Parser.LINE_DirectiveContext ctx) {
        this.filename = ctx.FILENAMELIT().getText();
        this.lineNum = ctx.INTLIT() != null ? Integer.parseInt(ctx.INTLIT().getText()) : 1;
        --this.lineNum;
        this.pauseLineIncrement = false;
        this.out.append(LabelVisitor.reflowTokens(ctx) + System.lineSeparator());
        return null;
    }

    @Override
    public Void visitLINE_BEGIN_Directive(CPUSim64v2Parser.LINE_BEGIN_DirectiveContext ctx) {
        this.filename = ctx.FILENAMELIT().getText();
        this.lineNum = ctx.INTLIT() != null ? Integer.parseInt(ctx.INTLIT().getText()) : 1;
        this.pauseLineIncrement = true;
        this.out.append(LabelVisitor.reflowTokens(ctx) + System.lineSeparator());
        return null;
    }

    @Override
    public Void visitLINE_END_Directive(CPUSim64v2Parser.LINE_END_DirectiveContext ctx) {
        this.pauseLineIncrement = false;
        this.out.append(LabelVisitor.reflowTokens(ctx) + System.lineSeparator());
        return null;
    }

    @Override
    public Void visitBLOCK_BEGIN_Directive(CPUSim64v2Parser.BLOCK_BEGIN_DirectiveContext ctx) {
        String blockname = null;
        if (ctx.IDENT() != null) {
            blockname = ctx.IDENT().getText();
            if (blockname.contains("$")) {
                blockname = null;
            }
        } else if (ctx.BLOCK_IDENT() != null) {
            blockname = ctx.BLOCK_IDENT().getText();
        }
        if (blockname == null) {
            throw new IllegalArgumentException(".block directive must have an argument!");
        }
        if (blockname.contains("{}") || blockname.contains("%d") || blockname.contains("%x")) {
            blockname = String.format(blockname.replace("{}", "%04x"), ++this.blockCount);
        }
        this.blockNames.push(blockname);
        this.out.append(LabelVisitor.reflowTokens(ctx) + System.lineSeparator());
        return null;
    }

    @Override
    public Void visitBLOCK_END_Directive(CPUSim64v2Parser.BLOCK_END_DirectiveContext ctx) {
        this.blockNames.pop();
        this.out.append(LabelVisitor.reflowTokens(ctx) + System.lineSeparator());
        return null;
    }

    @Override
    protected Void defaultResult() {
        return null;
    }

    private static String reflowTokens(ParserRuleContext ctx) {
        Token start = ctx.getStart();
        Token stop = ctx.getStop();
        if (start == null || stop == null) {
            return "";
        }
        return start.getInputStream().getText(Interval.of(start.getStartIndex(), stop.getStopIndex()));
    }

    public String gatherLabels(String src) {
        CodePointCharStream input = CharStreams.fromString(src);
        CPUSim64v2Lexer lex = new CPUSim64v2Lexer(input);
        CollectingErrorListener lexerListener = new CollectingErrorListener(this.errors, null);
        lex.removeErrorListeners();
        lex.addErrorListener(lexerListener);
        CommonTokenStream toks = new CommonTokenStream(lex);
        CPUSim64v2Parser parser = new CPUSim64v2Parser(toks);
        CollectingErrorListener parserListener = new CollectingErrorListener(this.errors, null);
        parser.removeErrorListeners();
        parser.addErrorListener(parserListener);
        CPUSim64v2Parser.ProgramContext tree = parser.program();
        this.visit(tree);
        Map<Integer, String> lineMap = this.getLineMap();
        for (int i = 0; i < this.errors.size(); ++i) {
            int preLine;
            String mapped;
            Matcher m;
            String s = this.errors.get(i);
            if (!s.startsWith("Preprocessed line") || !(m = Pattern.compile("Preprocessed line (\\d+)").matcher(s)).find() || (mapped = lineMap.get(preLine = Integer.parseInt(m.group(1)))) == null) continue;
            this.errors.set(i, m.replaceAll("Line " + mapped));
        }
        return this.out.toString();
    }
}

