/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64v2;

import cloud.lesh.CPUSim64v2.LiteralSubstitutionBaseVisitor;
import cloud.lesh.CPUSim64v2.LiteralSubstitutionLexer;
import cloud.lesh.CPUSim64v2.LiteralSubstitutionParser;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;

public class LiteralRewriter
extends LiteralSubstitutionBaseVisitor<Void> {
    private final StringBuilder out = new StringBuilder();
    private final List<String> floats = new ArrayList<String>();
    private final List<String> strings = new ArrayList<String>();

    public String rewrite(String src) {
        int i;
        CodePointCharStream input = CharStreams.fromString(src);
        LiteralSubstitutionLexer lexer = new LiteralSubstitutionLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        LiteralSubstitutionParser parser = new LiteralSubstitutionParser(tokens);
        LiteralSubstitutionParser.FileContext tree = parser.file();
        this.visit(tree);
        this.out.append(System.lineSeparator());
        for (i = 0; i < this.floats.size(); ++i) {
            this.out.append(LiteralRewriter.symFP(i + 1)).append(": .DCF ").append(this.floats.get(i)).append(System.lineSeparator());
        }
        for (i = 0; i < this.strings.size(); ++i) {
            this.out.append(LiteralRewriter.symSTR(i + 1)).append(": .DCS ").append(this.strings.get(i)).append(System.lineSeparator());
        }
        return this.out.toString();
    }

    private static String symFP(int i) {
        return String.format("__FP_%d", i);
    }

    private static String symSTR(int i) {
        return String.format("__STR_%d", i);
    }

    @Override
    public Void visitFile(LiteralSubstitutionParser.FileContext ctx) {
        return (Void)this.visitChildren(ctx);
    }

    @Override
    public Void visitPiece(LiteralSubstitutionParser.PieceContext ctx) {
        Token t = ctx.getStart();
        switch (t.getType()) {
            case 4: {
                if (this.floats.contains(t.getText())) {
                    int idx = this.floats.indexOf(t.getText()) + 1;
                    this.out.append(LiteralRewriter.symFP(idx));
                    break;
                }
                int idx = this.floats.size() + 1;
                this.floats.add(t.getText());
                this.out.append(LiteralRewriter.symFP(idx));
                break;
            }
            case 2: {
                if (this.strings.contains(t.getText())) {
                    int idx = this.strings.indexOf(t.getText()) + 1;
                    this.out.append(LiteralRewriter.symSTR(idx));
                    break;
                }
                int idx = this.strings.size() + 1;
                this.strings.add(t.getText());
                this.out.append(LiteralRewriter.symSTR(idx));
                break;
            }
            case 3: {
                int val = this.parseCharLiteral(t.getText());
                this.out.append(String.format("0x%X", val));
                break;
            }
            default: {
                this.out.append(t.getText());
            }
        }
        return null;
    }

    private int parseCharLiteral(String s) {
        if (s == null || s.isEmpty()) {
            return 65533;
        }
        if (s.length() >= 2 && s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            s = s.substring(1, s.length() - 1);
        }
        if (s.isEmpty()) {
            return 65533;
        }
        if (s.charAt(0) != '\\') {
            return s.codePointAt(0);
        }
        if (s.length() == 1) {
            return 65533;
        }
        char next = s.charAt(1);
        switch (next) {
            case 'n': {
                return 10;
            }
            case 't': {
                return 9;
            }
            case 'r': {
                return 13;
            }
            case 'b': {
                return 8;
            }
            case 'f': {
                return 12;
            }
            case '\\': {
                return 92;
            }
            case '\'': {
                return 39;
            }
            case '\"': {
                return 34;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                char c;
                int i = 1;
                int val = 0;
                for (int count = 0; i < s.length() && count < 3 && (c = s.charAt(i)) >= '0' && c <= '7'; ++i, ++count) {
                    val = (val << 3) + (c - 48);
                }
                return val & 0xFF;
            }
            case 'U': 
            case 'u': {
                String hex;
                if (s.length() >= 6 && (hex = s.substring(2, 6)).chars().allMatch(ch -> Character.digit(ch, 16) != -1)) {
                    return Integer.parseInt(hex, 16);
                }
                return 65533;
            }
        }
        return next;
    }
}

