/*
 * Decompiled with CFR 0.152.
 */
package cloud.lesh.CPUSim64v2;

import cloud.lesh.CPUSim64v2.FilePortHandler;
import cloud.lesh.CPUSim64v2.InterruptHandler;
import cloud.lesh.CPUSim64v2.Opcode;
import cloud.lesh.CPUSim64v2.PortHandler;
import cloud.lesh.CPUSim64v2.RawFilePortHandler;
import cloud.lesh.CPUSim64v2.Simulator;
import cloud.lesh.CPUSim64v2.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.BreakIterator;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StdInterruptHandler
extends InterruptHandler {
    private Simulator cpu;
    public static final int iINT_MIN = 1;
    public static final int iINT_MAX = 2;
    public static final int iFLOAT_MIN = 3;
    public static final int iFLOAT_LOWEST = 4;
    public static final int iFLOAT_MAX = 5;
    public static final int iNEGATIVE_INFINITY = 6;
    public static final int iPOSITIVE_INFINITY = 7;
    public static final int iNAN = 8;
    public static final int iCYCLES = 10;
    public static final int iCLOCK = 11;
    public static final int iSAVE = 12;
    public static final int iSAVE_FP = 13;
    public static final int iRESTORE = 14;
    public static final int iRESTORE_FP = 15;
    public static final int iPrintCPUState = 16;
    public static final int iALLOC = 20;
    public static final int iREALLOC = 21;
    public static final int iFREE = 22;
    public static final int iMEMMOVE = 23;
    public static final int iMEMCLEAR = 24;
    public static final int iALLOC_COUNT = 25;
    public static final int iFREE_COUNT = 26;
    public static final int iALLOC_SIZE = 27;
    public static final int iFREE_SIZE = 28;
    public static final int iWALK_HEAP = 29;
    public static final int iARGC = 30;
    public static final int iARGS = 31;
    public static final int iEXIT = 32;
    public static final int iSYSTEM = 33;
    public static final int iGET_PID = 34;
    public static final int iNEXT_PID = 35;
    public static final int iGET_NUM_CORES = 36;
    public static final int iFORK = 37;
    public static final int iWAIT = 38;
    public static final int iWAIT_PID = 39;
    public static final int iTHREAD = 40;
    public static final int iJOIN_THREAD = 41;
    public static final int iSLEEP = 42;
    public static final int iWAKE_THREAD = 43;
    public static final int iPI = 100;
    public static final int iE = 101;
    public static final int iABS_FP = 102;
    public static final int iABS = 103;
    public static final int iCEIL = 104;
    public static final int iFLOOR = 105;
    public static final int iROUND = 106;
    public static final int iSQRT = 107;
    public static final int iEXP = 108;
    public static final int iLOG = 109;
    public static final int iPOW = 110;
    public static final int iREMAINDER = 111;
    public static final int iMAX_FP = 112;
    public static final int iMIN_FP = 113;
    public static final int iMAX = 114;
    public static final int iMIN = 115;
    public static final int iRANDOM = 116;
    public static final int iRAND = 117;
    public static final int iTO_DEGREES = 118;
    public static final int iTO_RADIANS = 119;
    public static final int iSIN = 120;
    public static final int iCOS = 121;
    public static final int iTAN = 122;
    public static final int iASIN = 123;
    public static final int iACOS = 124;
    public static final int iATAN = 125;
    public static final int iATAN2 = 126;
    public static final int iSINH = 127;
    public static final int iCOSH = 128;
    public static final int iTANH = 129;
    public static final int iASINH = 130;
    public static final int iACOSH = 131;
    public static final int iATANH = 132;
    public static final int iPUT_NL = 200;
    public static final int iPUT_INT = 201;
    public static final int iPUT_DEC = 202;
    public static final int iPUT_HEX = 203;
    public static final int iPUT_FP = 204;
    public static final int iPUTS = 205;
    public static final int iPUT_LINE = 206;
    public static final int iGET_INT = 207;
    public static final int iGET_DEC = 208;
    public static final int iGET_HEX = 209;
    public static final int iGET_FP = 210;
    public static final int iGETS = 211;
    public static final int iGET_LINE = 212;
    public static final int iPRINTF = 213;
    public static final int iCOND_PRINTF = 214;
    public static final int iOPEN_FILE_READ = 220;
    public static final int iOPEN_FILE_WRITE = 221;
    public static final int iOPEN_FILE_APPEND = 222;
    public static final int iOPEN_RAW_FILE_READ = 223;
    public static final int iOPEN_RAW_FILE_WRITE = 224;
    public static final int iOPEN_RAW_FILE_APPEND = 225;
    public static final int iCLOSE_FILE = 226;
    public static final int iFLUSH = 227;
    public static final int iDELETE_FILE = 228;
    public static final int iMAKE_DIR = 229;
    public static final int iDELETE_DIR = 230;
    public static final int iIS_DIR = 231;
    public static final int iIS_FILE = 232;
    public static final int iFILE_EXISTS = 233;
    public static final int iFILES = 234;
    public static final int iTEMP_DIR = 235;
    public static final int iTEMP_FILE = 236;
    public static final int iFMT_DEC = 301;
    public static final int iFMT_HEX = 302;
    public static final int iFMT_FLOAT = 303;
    public static final int iPARSE_INT = 304;
    public static final int iPARSE_DEC = 305;
    public static final int iPARSE_HEX = 306;
    public static final int iPARSE_FLOAT = 307;
    public static final int iSPRINTF = 308;
    public static final int iFORMAT = 309;
    public static final int iTO_LOWER = 310;
    public static final int iTO_UPPER = 311;
    public static final int iTO_LOWER_STR = 312;
    public static final int iTO_UPPER_STR = 313;
    public static final int iSTRCMP = 314;
    public static final int iSUBSTRING = 315;
    public static final int iPREFIX = 316;
    public static final int iSUFFIX = 317;
    public static final int iCHAR_SEARCH = 318;
    public static final int iLAST_CHAR_SEARCH = 319;
    public static final int iSUBSTRING_SEARCH = 320;
    public static final int iLAST_SUBSTRING_SEARCH = 321;
    public static final int iSTRICMP = 322;
    public static final int iGET_CODEPOINTS = 323;
    public static final int iFROM_CODEPOINTS = 324;
    public static final int iCOUNT_GLHYPHS = 325;
    public static final int iHASHCODE = 326;
    public static final int iTRIM = 327;
    public static final int iMATCHES = 350;
    public static final int iREPLACE_FIRST = 351;
    public static final int iREPLACE_ALL = 352;
    public static final int iSPLIT = 353;
    public static final int iJOIN = 354;
    public static final int iSTRCAT = 355;
    private long argv_ptr = 0L;

    public StdInterruptHandler(Simulator c) {
        this.cpu = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatch(int id) throws Simulator.CPUException {
        boolean result = true;
        Object s = "";
        switch (id) {
            case 1: {
                this.cpu.setR(0, Long.MIN_VALUE);
                break;
            }
            case 2: {
                this.cpu.setR(0, Long.MAX_VALUE);
                break;
            }
            case 3: {
                this.cpu.setFP(0, -1.7976931348623157E308);
                break;
            }
            case 4: {
                this.cpu.setFP(0, Double.MIN_VALUE);
                break;
            }
            case 5: {
                this.cpu.setFP(0, Double.MAX_VALUE);
                break;
            }
            case 6: {
                this.cpu.setFP(0, Double.NEGATIVE_INFINITY);
                break;
            }
            case 7: {
                this.cpu.setFP(0, Double.POSITIVE_INFINITY);
                break;
            }
            case 8: {
                this.cpu.setFP(0, Double.NaN);
                break;
            }
            case 10: {
                this.cpu.setR(0, this.cpu.getCycles());
                break;
            }
            case 11: {
                this.cpu.setR(0, this.cpu.getClock());
                break;
            }
            case 12: {
                this.cpu.opSAVE(Simulator.Decoded.decode(Simulator.encT0(Opcode.SAVE.code, 2, 2, 0, 0, 0, 32 - 4, 0, 0)));
                break;
            }
            case 13: {
                this.cpu.opSAVE(Simulator.Decoded.decode(Simulator.encT0(Opcode.SAVE.code, 3, 3, 0, 0, 0, 32 - 1, 0, 0)));
                break;
            }
            case 14: {
                this.cpu.opRESTORE(Simulator.Decoded.decode(Simulator.encT0(Opcode.RESTORE.code, 2, 2, 0, 0, 0, 32 - 4, 0, 0)));
                break;
            }
            case 15: {
                this.cpu.opRESTORE(Simulator.Decoded.decode(Simulator.encT0(Opcode.RESTORE.code, 3, 3, 0, 0, 0, 32 - 1, 0, 0)));
                break;
            }
            case 16: {
                this.cpu.printCPUState();
                break;
            }
            case 20: {
                this.cpu.setR(0, this.cpu.alloc((int)this.cpu.getR(1)));
                break;
            }
            case 21: {
                this.cpu.setR(0, this.cpu.realloc((int)this.cpu.getR(1), (int)this.cpu.getR(2)));
                break;
            }
            case 22: {
                this.cpu.free((int)this.cpu.getR(1));
                break;
            }
            case 23: {
                long dest = this.cpu.getR(1);
                long src = this.cpu.getR(2);
                long count = this.cpu.getR(3);
                this.cpu.memmove(dest, src, count);
                break;
            }
            case 24: {
                long dest = this.cpu.getR(1);
                long count = this.cpu.getR(2);
                this.cpu.memclear((int)dest, (int)count);
                break;
            }
            case 25: {
                this.cpu.setR(0, this.cpu.countHeapBlocks(true, false));
                break;
            }
            case 26: {
                this.cpu.setR(0, this.cpu.countHeapBlocks(false, true));
                break;
            }
            case 27: {
                this.cpu.setR(0, this.cpu.countHeapSize(true, false));
                break;
            }
            case 28: {
                this.cpu.setR(0, this.cpu.countHeapSize(false, true));
                break;
            }
            case 29: {
                this.cpu.walkHeap();
                break;
            }
            case 30: {
                int argc = this.cpu.getCommandLineCount();
                this.cpu.setR(0, argc);
                break;
            }
            case 31: {
                int argc = this.cpu.getCommandLineCount();
                if (this.argv_ptr == 0L && argc > 0) {
                    this.argv_ptr = this.cpu.alloc(argc);
                    for (int i = 0; i < argc; ++i) {
                        String arg = this.cpu.getCommandLineArg(i);
                        this.cpu.memWrite(this.argv_ptr + (long)i, this.cpu.allocString(arg));
                    }
                }
                long v = this.cpu.getR(1);
                v = this.argv_ptr > 0L && v >= 0L && v < (long)argc ? this.cpu.memRead(this.argv_ptr + v) : 0L;
                this.cpu.setR(0, v);
                break;
            }
            case 32: {
                this.cpu.exit((int)this.cpu.getR(1));
                break;
            }
            case 33: {
                s = this.cpu.convertString(this.cpu.getR(1));
                try {
                    Runtime run = Runtime.getRuntime();
                    Process pr = run.exec((String)s);
                    pr.waitFor();
                    BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                    while ((s = buf.readLine()) != null) {
                        System.out.println((String)s);
                    }
                    this.cpu.setR(0, pr.exitValue());
                    break;
                }
                catch (Exception ex) {
                    Simulator simulator = this.cpu;
                    Objects.requireNonNull(simulator);
                    throw simulator.new Simulator.CPUException(ex.getMessage());
                }
            }
            case 37: {
                this.cpu.setR(0, this.cpu.fork());
                break;
            }
            case 38: {
                this.cpu.waitAll();
                break;
            }
            case 39: {
                this.cpu.waitPID((int)this.cpu.getR(1));
                break;
            }
            case 40: {
                this.cpu.setR(0, this.cpu.thread(this.cpu.getR(1), this.cpu.getR(2)));
                break;
            }
            case 41: {
                this.cpu.joinThread((int)this.cpu.getR(1));
                break;
            }
            case 42: {
                try {
                    Thread.sleep(this.cpu.getR(1));
                }
                catch (InterruptedException ex) {}
                break;
            }
            case 43: {
                this.cpu.wakeThread((int)this.cpu.getR(1));
                break;
            }
            case 34: {
                this.cpu.setR(0, this.cpu.getPID());
                break;
            }
            case 35: {
                this.cpu.setR(0, this.cpu.nextPID());
                break;
            }
            case 36: {
                this.cpu.setR(0, Runtime.getRuntime().availableProcessors());
                break;
            }
            case 100: {
                this.cpu.setFP(0, Math.PI);
                break;
            }
            case 101: {
                this.cpu.setFP(0, Math.E);
                break;
            }
            case 102: {
                this.cpu.setFP(0, Math.abs(this.cpu.getFP(1)));
                break;
            }
            case 103: {
                this.cpu.setR(0, Math.abs(this.cpu.getR(1)));
                break;
            }
            case 104: {
                this.cpu.setFP(0, Math.ceil(this.cpu.getFP(1)));
                break;
            }
            case 105: {
                this.cpu.setFP(0, Math.floor(this.cpu.getFP(1)));
                break;
            }
            case 106: {
                this.cpu.setFP(0, Math.copySign(Math.floor(Math.abs(this.cpu.getFP(1)) + 0.5), this.cpu.getFP(1)));
                break;
            }
            case 107: {
                this.cpu.setFP(0, Math.sqrt(this.cpu.getFP(1)));
                break;
            }
            case 108: {
                this.cpu.setFP(0, Math.exp(this.cpu.getFP(1)));
                break;
            }
            case 109: {
                this.cpu.setFP(0, Math.log(this.cpu.getFP(1)));
                break;
            }
            case 110: {
                this.cpu.setFP(0, Math.pow(this.cpu.getFP(1), this.cpu.getFP(2)));
                break;
            }
            case 111: {
                this.cpu.setFP(0, Math.IEEEremainder(this.cpu.getFP(1), this.cpu.getFP(2)));
                break;
            }
            case 112: {
                this.cpu.setFP(0, Math.max(this.cpu.getFP(1), this.cpu.getFP(2)));
                break;
            }
            case 113: {
                this.cpu.setFP(0, Math.min(this.cpu.getFP(1), this.cpu.getFP(2)));
                break;
            }
            case 114: {
                this.cpu.setR(0, Math.max(this.cpu.getR(1), this.cpu.getR(2)));
                break;
            }
            case 115: {
                this.cpu.setR(0, Math.min(this.cpu.getR(1), this.cpu.getR(2)));
                break;
            }
            case 116: {
                this.cpu.setFP(0, Math.random());
                break;
            }
            case 117: {
                this.cpu.setR(0, (long)Math.floor(Math.random() * (double)(this.cpu.getR(2) - this.cpu.getR(1) + 1L)) + this.cpu.getR(1));
                break;
            }
            case 118: {
                this.cpu.setFP(0, Math.toDegrees(this.cpu.getFP(1)));
                break;
            }
            case 119: {
                this.cpu.setFP(0, Math.toRadians(this.cpu.getFP(1)));
                break;
            }
            case 120: {
                this.cpu.setFP(0, Math.sin(this.cpu.getFP(1)));
                break;
            }
            case 121: {
                this.cpu.setFP(0, Math.cos(this.cpu.getFP(1)));
                break;
            }
            case 122: {
                this.cpu.setFP(0, Math.tan(this.cpu.getFP(1)));
                break;
            }
            case 123: {
                this.cpu.setFP(0, Math.asin(this.cpu.getFP(1)));
                break;
            }
            case 124: {
                this.cpu.setFP(0, Math.acos(this.cpu.getFP(1)));
                break;
            }
            case 125: {
                this.cpu.setFP(0, Math.atan(this.cpu.getFP(1)));
                break;
            }
            case 126: {
                this.cpu.setFP(0, Math.atan2(this.cpu.getFP(1), this.cpu.getFP(2)));
                break;
            }
            case 127: {
                this.cpu.setFP(0, Math.sinh(this.cpu.getFP(1)));
                break;
            }
            case 128: {
                this.cpu.setFP(0, Math.cosh(this.cpu.getFP(1)));
                break;
            }
            case 129: {
                this.cpu.setFP(0, Math.tanh(this.cpu.getFP(1)));
                break;
            }
            case 130: {
                this.cpu.setFP(0, Utils.asinh(this.cpu.getFP(1)));
                break;
            }
            case 131: {
                this.cpu.setFP(0, Utils.acosh(this.cpu.getFP(1)));
                break;
            }
            case 132: {
                this.cpu.setFP(0, Utils.atanh(this.cpu.getFP(1)));
                break;
            }
            case 200: {
                PortHandler ph = this.cpu.getPortHandler((int)this.cpu.getR(1));
                if (ph == null) break;
                ph.setPort(this.cpu.getR(1));
                ph.writeChar(10);
                break;
            }
            case 201: {
                s = Long.toString(this.cpu.getR(2), (int)this.cpu.getR(3));
                PortHandler ph = this.cpu.getPortHandler((int)this.cpu.getR(1));
                if (ph == null) break;
                ph.setPort(this.cpu.getR(1));
                int len = ((String)s).length();
                PortHandler pr = ph;
                synchronized (pr) {
                    for (int pos = 0; pos < len; ++pos) {
                        ph.writeChar(((String)s).charAt(pos));
                    }
                    break;
                }
            }
            case 202: {
                s = Long.toString(this.cpu.getR(2));
                PortHandler ph = this.cpu.getPortHandler((int)this.cpu.getR(1));
                if (ph == null) break;
                ph.setPort(this.cpu.getR(1));
                int len = ((String)s).length();
                PortHandler pr = ph;
                synchronized (pr) {
                    for (int pos = 0; pos < len; ++pos) {
                        ph.writeChar(((String)s).charAt(pos));
                    }
                    break;
                }
            }
            case 203: {
                s = this.cpu.getR(3) <= 0L ? String.format("%X", this.cpu.getR(2)) : String.format("%0" + this.cpu.getR(3) + "X", this.cpu.getR(2));
                PortHandler ph = this.cpu.getPortHandler((int)this.cpu.getR(1));
                if (ph == null) break;
                ph.setPort(this.cpu.getR(1));
                int len = ((String)s).length();
                PortHandler pr = ph;
                synchronized (pr) {
                    for (int pos = 0; pos < len; ++pos) {
                        ph.writeChar(((String)s).charAt(pos));
                    }
                    break;
                }
            }
            case 204: {
                s = String.format("%." + this.cpu.getR(2) + "f", this.cpu.getFP(1));
                PortHandler ph = this.cpu.getPortHandler((int)this.cpu.getR(1));
                if (ph == null) break;
                ph.setPort(this.cpu.getR(1));
                int len = ((String)s).length();
                PortHandler pr = ph;
                synchronized (pr) {
                    for (int pos = 0; pos < len; ++pos) {
                        ph.writeChar(((String)s).charAt(pos));
                    }
                    break;
                }
            }
            case 205: {
                PortHandler ph = this.cpu.getPortHandler((int)this.cpu.getR(1));
                if (ph == null) break;
                ph.setPort(this.cpu.getR(1));
                int pos = (int)this.cpu.getR(2);
                PortHandler pr = ph;
                synchronized (pr) {
                    s = this.cpu.convertString(pos);
                    ((String)s).codePoints().forEach(cp -> ph.writeChar(cp));
                    break;
                }
            }
            case 206: {
                PortHandler ph = this.cpu.getPortHandler((int)this.cpu.getR(1));
                if (ph == null) break;
                ph.setPort(this.cpu.getR(1));
                int pos = (int)this.cpu.getR(2);
                PortHandler pr = ph;
                synchronized (pr) {
                    s = this.cpu.convertString(pos);
                    ((String)s).codePoints().forEach(cp -> ph.writeChar(cp));
                    ph.writeChar(10);
                    break;
                }
            }
            case 207: {
                long v;
                int i = (int)this.cpu.getR(2);
                this.cpu.setR(2, this.cpu.alloc(65L));
                this.dispatch(211);
                try {
                    s = this.cpu.convertString(this.cpu.getR(2));
                    v = Integer.parseInt((String)s, i);
                }
                catch (Exception e) {
                    Simulator simulator = this.cpu;
                    Objects.requireNonNull(simulator);
                    throw simulator.new Simulator.CPUException("Can't convert \"" + (String)s + "\" to an integer base " + i + "!");
                }
                this.cpu.free((int)this.cpu.getR(2));
                this.cpu.setR(0, v);
                break;
            }
            case 208: {
                this.cpu.setR(2, 10L);
                this.dispatch(207);
                break;
            }
            case 209: {
                this.cpu.setR(2, 16L);
                this.dispatch(207);
                break;
            }
            case 210: {
                double f;
                this.cpu.setR(2, this.cpu.alloc(65L));
                this.dispatch(211);
                try {
                    s = this.cpu.convertString(this.cpu.getR(2));
                    f = Double.parseDouble((String)s);
                }
                catch (Exception e) {
                    Simulator simulator = this.cpu;
                    Objects.requireNonNull(simulator);
                    throw simulator.new Simulator.CPUException("Can't convert \"" + (String)s + "\" to a floating point!");
                }
                this.cpu.free((int)this.cpu.getR(2));
                this.cpu.setFP(0, f);
                break;
            }
            case 211: {
                int cp2;
                PortHandler ph = this.cpu.getPortHandler((int)this.cpu.getR(1));
                if (ph == null) break;
                ph.setPort(this.cpu.getR(1));
                long pos = 0L;
                Vector<Integer> codepoints = new Vector<Integer>();
                PortHandler count = ph;
                synchronized (count) {
                    while ((cp2 = ph.readChar()) != -1) {
                        if (Character.isWhitespace(cp2)) {
                            if (!codepoints.isEmpty()) break;
                            continue;
                        }
                        codepoints.add(cp2);
                    }
                }
                int[] cps = codepoints.stream().mapToInt(Integer::intValue).toArray();
                s = new String(cps, 0, cps.length);
                long newAlloc = this.cpu.allocString((String)s, this.cpu.getR(2));
                this.cpu.setR(2, newAlloc);
                if (cp2 == -1 && ((String)s).isEmpty()) {
                    this.cpu.setR(0, -1L);
                    break;
                }
                this.cpu.setR(0, ((String)s).length());
                break;
            }
            case 212: {
                int cp3;
                PortHandler ph = this.cpu.getPortHandler((int)this.cpu.getR(1));
                if (ph == null) break;
                ph.setPort(this.cpu.getR(1));
                long pos = 0L;
                Vector<Integer> codepoints = new Vector<Integer>();
                Object cps = ph;
                synchronized (cps) {
                    while ((cp3 = ph.readChar()) != -1 && cp3 != 10) {
                        if (cp3 == 13) continue;
                        codepoints.add(cp3);
                    }
                }
                cps = codepoints.stream().mapToInt(Integer::intValue).toArray();
                s = new String((int[])cps, 0, ((Object)cps).length);
                long newAlloc = this.cpu.allocString((String)s, this.cpu.getR(2));
                this.cpu.setR(2, newAlloc);
                if (cp3 == -1 && ((String)s).isEmpty()) {
                    this.cpu.setR(0, -1L);
                    break;
                }
                this.cpu.setR(0, ((String)s).length());
                break;
            }
            case 213: {
                long v = this.cpu.memRead(this.cpu.getR(29) + 3L);
                PortHandler ph = this.cpu.getPortHandler((int)v);
                if (ph == null) break;
                ph.setPort(v);
                s = this.sprintf(4);
                ((String)s).codePoints().forEach(cp -> ph.writeChar(cp));
                break;
            }
            case 214: {
                long v;
                PortHandler ph;
                boolean b;
                boolean bl = b = this.cpu.memRead(this.cpu.getR(29) + 3L) != 0L;
                if (!b || (ph = this.cpu.getPortHandler((int)(v = this.cpu.memRead(this.cpu.getR(29) + 4L)))) == null) break;
                ph.setPort(v);
                s = this.sprintf(5);
                int len = ((String)s).length();
                PortHandler pr = ph;
                synchronized (pr) {
                    for (int pos = 0; pos < len; ++pos) {
                        ph.writeChar(((String)s).charAt(pos));
                    }
                    break;
                }
            }
            case 220: {
                int i = (int)this.cpu.getR(1);
                PortHandler ph = this.cpu.getPortHandler(i);
                if (ph == null) {
                    try {
                        this.cpu.setPortHandler(i, new FilePortHandler(this.cpu, 0, this.cpu.convertString(this.cpu.getR(2))));
                        this.cpu.setR(0, -1L);
                    }
                    catch (Simulator.CPUException ex) {
                        this.cpu.setR(0, 0L);
                    }
                    break;
                }
                Simulator simulator = this.cpu;
                Objects.requireNonNull(simulator);
                throw simulator.new Simulator.CPUException("Port " + i + " already mapped!");
            }
            case 221: {
                int i = (int)this.cpu.getR(1);
                PortHandler ph = this.cpu.getPortHandler(i);
                if (ph == null) {
                    try {
                        this.cpu.setPortHandler(i, new FilePortHandler(this.cpu, 1, this.cpu.convertString(this.cpu.getR(2))));
                        this.cpu.setR(0, -1L);
                    }
                    catch (Simulator.CPUException ex) {
                        this.cpu.setR(0, 0L);
                    }
                    break;
                }
                Simulator simulator = this.cpu;
                Objects.requireNonNull(simulator);
                throw simulator.new Simulator.CPUException("Port " + i + " already mapped!");
            }
            case 222: {
                int i = (int)this.cpu.getR(1);
                PortHandler ph = this.cpu.getPortHandler(i);
                if (ph == null) {
                    try {
                        this.cpu.setPortHandler(i, new FilePortHandler(this.cpu, 2, this.cpu.convertString(this.cpu.getR(2))));
                        this.cpu.setR(0, -1L);
                    }
                    catch (Simulator.CPUException ex) {
                        this.cpu.setR(0, 0L);
                    }
                    break;
                }
                Simulator simulator = this.cpu;
                Objects.requireNonNull(simulator);
                throw simulator.new Simulator.CPUException("Port " + i + " already mapped!");
            }
            case 223: {
                int i = (int)this.cpu.getR(1);
                PortHandler ph = this.cpu.getPortHandler(i);
                if (ph == null) {
                    try {
                        this.cpu.setPortHandler(i, new RawFilePortHandler(this.cpu, this.cpu.convertString(this.cpu.getR(2)), 0));
                        this.cpu.setR(0, -1L);
                    }
                    catch (Simulator.CPUException ex) {
                        this.cpu.setR(0, 0L);
                    }
                    break;
                }
                Simulator simulator = this.cpu;
                Objects.requireNonNull(simulator);
                throw simulator.new Simulator.CPUException("Port " + i + " already mapped!");
            }
            case 224: {
                int i = (int)this.cpu.getR(1);
                PortHandler ph = this.cpu.getPortHandler(i);
                if (ph == null) {
                    try {
                        this.cpu.setPortHandler(i, new RawFilePortHandler(this.cpu, this.cpu.convertString(this.cpu.getR(2)), 1));
                        this.cpu.setR(0, -1L);
                    }
                    catch (Simulator.CPUException ex) {
                        this.cpu.setR(0, 0L);
                    }
                    break;
                }
                Simulator simulator = this.cpu;
                Objects.requireNonNull(simulator);
                throw simulator.new Simulator.CPUException("Port " + i + " already mapped!");
            }
            case 225: {
                int i = (int)this.cpu.getR(1);
                PortHandler ph = this.cpu.getPortHandler(i);
                if (ph == null) {
                    try {
                        this.cpu.setPortHandler(i, new RawFilePortHandler(this.cpu, this.cpu.convertString(this.cpu.getR(2)), 2));
                        this.cpu.setR(0, -1L);
                    }
                    catch (Simulator.CPUException ex) {
                        this.cpu.setR(0, 0L);
                    }
                    break;
                }
                Simulator simulator = this.cpu;
                Objects.requireNonNull(simulator);
                throw simulator.new Simulator.CPUException("Port " + i + " already mapped!");
            }
            case 226: {
                PortHandler ph = this.cpu.getPortHandler((int)this.cpu.getR(1));
                if (ph != null) {
                    ph.setPort((int)this.cpu.getR(1));
                    ph.close();
                    this.cpu.setPortHandler((int)this.cpu.getR(1), null);
                    break;
                }
                Simulator simulator = this.cpu;
                Objects.requireNonNull(simulator);
                throw simulator.new Simulator.CPUException("Port " + this.cpu.getR(1) + " not mapped!");
            }
            case 227: {
                PortHandler ph = this.cpu.getPortHandler((int)this.cpu.getR(1));
                if (ph != null) {
                    ph.setPort(this.cpu.getR(1));
                    ph.flush();
                    break;
                }
                Simulator simulator = this.cpu;
                Objects.requireNonNull(simulator);
                throw simulator.new Simulator.CPUException("Port " + this.cpu.getR(1) + " not mapped!");
            }
            case 228: {
                s = this.cpu.convertString(this.cpu.getR(1));
                File filespec = new File((String)s);
                boolean b = false;
                if (filespec.isFile()) {
                    b = filespec.delete();
                }
                this.cpu.setR(0, b ? -1L : 0L);
                break;
            }
            case 229: {
                s = this.cpu.convertString(this.cpu.getR(1));
                File filespec = new File((String)s);
                boolean b = filespec.mkdir();
                this.cpu.setR(0, b ? -1L : 0L);
                break;
            }
            case 230: {
                s = this.cpu.convertString(this.cpu.getR(1));
                File filespec = new File((String)s);
                boolean b = false;
                if (filespec.isDirectory()) {
                    b = filespec.delete();
                }
                this.cpu.setR(0, b ? -1L : 0L);
                break;
            }
            case 231: {
                s = this.cpu.convertString(this.cpu.getR(1));
                File filespec = new File((String)s);
                this.cpu.setR(0, filespec.isDirectory() ? -1L : 0L);
                break;
            }
            case 232: {
                s = this.cpu.convertString(this.cpu.getR(1));
                File filespec = new File((String)s);
                this.cpu.setR(0, filespec.isFile() ? -1L : 0L);
                break;
            }
            case 233: {
                s = this.cpu.convertString(this.cpu.getR(1));
                File filespec = new File((String)s);
                this.cpu.setR(0, filespec.exists() ? -1L : 0L);
                break;
            }
            case 234: {
                s = this.cpu.convertString(this.cpu.getR(1));
                if (!((String)s).endsWith("/")) {
                    s = (String)s + "/";
                }
                File filespec = new File((String)s);
                String[] filelist = filespec.list();
                long resultArray = this.cpu.alloc(filelist.length + 1);
                for (int i = 0; i < filelist.length; ++i) {
                    this.cpu.memWrite(resultArray + (long)i + 1L, this.cpu.allocString((String)s + filelist[i]));
                }
                this.cpu.memWrite(resultArray, filelist.length);
                this.cpu.setR(0, resultArray);
                break;
            }
            case 235: {
                try {
                    s = this.cpu.convertString(this.cpu.getR(1));
                    File filespec = Files.createTempDirectory((String)s, new FileAttribute[0]).toFile();
                    this.cpu.setR(0, this.cpu.allocString(filespec.getAbsolutePath()));
                }
                catch (IOException ex) {
                    this.cpu.setR(0, 0L);
                }
                break;
            }
            case 236: {
                s = this.cpu.convertString(this.cpu.getR(2));
                try {
                    File filespec = File.createTempFile(this.cpu.convertString(this.cpu.getR(1)), (String)s);
                    this.cpu.setR(0, this.cpu.allocString(filespec.getAbsolutePath()));
                }
                catch (IOException ex) {
                    this.cpu.setR(0, 0L);
                }
                break;
            }
            case 301: {
                s = Long.toString(this.cpu.getR(1));
                this.cpu.setR(0, this.cpu.allocString((String)s));
                break;
            }
            case 302: {
                s = String.format("%0" + this.cpu.getR(2) + "X", this.cpu.getR(1));
                this.cpu.setR(0, this.cpu.allocString((String)s));
                break;
            }
            case 303: {
                s = String.format("%." + this.cpu.getR(1) + "f", this.cpu.getFP(1));
                this.cpu.setR(0, this.cpu.allocString((String)s));
                break;
            }
            case 304: {
                s = this.cpu.convertString(this.cpu.getR(1));
                this.cpu.setR(0, Long.decode((String)s));
                break;
            }
            case 305: {
                s = this.cpu.convertString(this.cpu.getR(1));
                this.cpu.setR(0, Long.parseLong((String)s, 10));
                break;
            }
            case 306: {
                s = this.cpu.convertString(this.cpu.getR(1));
                this.cpu.setR(0, Long.parseLong((String)s, 16));
                break;
            }
            case 307: {
                s = this.cpu.convertString(this.cpu.getR(1));
                this.cpu.setFP(0, Double.parseDouble((String)s));
                break;
            }
            case 308: {
                s = this.sprintf(3);
                this.cpu.setR(0, this.cpu.allocString((String)s));
                break;
            }
            case 309: {
                s = this.format(3);
                this.cpu.setR(0, this.cpu.allocString((String)s));
                break;
            }
            case 310: {
                long v = this.cpu.getR(1);
                v = Character.toLowerCase((int)v);
                this.cpu.setR(0, v);
                break;
            }
            case 311: {
                long v = this.cpu.getR(1);
                v = Character.toUpperCase((int)v);
                this.cpu.setR(0, v);
                break;
            }
            case 312: {
                s = this.cpu.convertString(this.cpu.getR(1));
                s = ((String)s).toLowerCase();
                this.cpu.setR(0, this.cpu.allocString((String)s));
                break;
            }
            case 313: {
                s = this.cpu.convertString(this.cpu.getR(1));
                s = ((String)s).toUpperCase();
                this.cpu.setR(0, this.cpu.allocString((String)s));
                break;
            }
            case 314: {
                String s1 = this.cpu.convertString((int)this.cpu.getR(1));
                String s2 = this.cpu.convertString((int)this.cpu.getR(2));
                this.cpu.setR(0, s1.compareTo(s2));
                break;
            }
            case 315: {
                s = this.cpu.convertString((int)this.cpu.getR(1));
                int start = Math.max(0, (int)this.cpu.getR(2));
                int stop = Math.max(0, (int)(this.cpu.getR(2) + this.cpu.getR(3)));
                int len = ((String)s).length();
                start = Math.min(len, start);
                stop = Math.min(len, stop);
                String sub = ((String)s).substring(start, stop);
                this.cpu.setR(0, this.cpu.allocString(sub));
                break;
            }
            case 316: {
                s = this.cpu.convertString((int)this.cpu.getR(1));
                String sub = ((String)s).substring(0, (int)this.cpu.getR(2));
                this.cpu.setR(0, this.cpu.allocString(sub));
                break;
            }
            case 317: {
                s = this.cpu.convertString((int)this.cpu.getR(1));
                String sub = ((String)s).substring(((String)s).length() - (int)this.cpu.getR(2), ((String)s).length());
                this.cpu.setR(0, this.cpu.allocString(sub));
                break;
            }
            case 318: {
                s = this.cpu.convertString((int)this.cpu.getR(1));
                int c = (int)this.cpu.getR(2);
                int i = (int)this.cpu.getR(3);
                i = Math.min(i, ((String)s).length());
                i = Math.max(0, i);
                long v = ((String)s).indexOf(c, i);
                this.cpu.setR(0, v);
                break;
            }
            case 319: {
                s = this.cpu.convertString((int)this.cpu.getR(1));
                int c = (int)this.cpu.getR(2);
                int i = (int)this.cpu.getR(3);
                i = Math.min(i, ((String)s).length());
                i = Math.max(0, i);
                long v = ((String)s).lastIndexOf(c, i);
                this.cpu.setR(0, v);
                break;
            }
            case 320: {
                s = this.cpu.convertString((int)this.cpu.getR(1));
                String substr = this.cpu.convertString((int)this.cpu.getR(2));
                int i = (int)this.cpu.getR(3);
                i = Math.min(i, ((String)s).length());
                i = Math.max(0, i);
                long v = ((String)s).indexOf(substr, i);
                this.cpu.setR(0, v);
                break;
            }
            case 321: {
                s = this.cpu.convertString((int)this.cpu.getR(1));
                String substr = this.cpu.convertString((int)this.cpu.getR(2));
                int i = (int)this.cpu.getR(3);
                i = Math.min(i, ((String)s).length());
                i = Math.max(0, i);
                long v = ((String)s).lastIndexOf(substr, i);
                this.cpu.setR(0, v);
                break;
            }
            case 322: {
                String s1 = this.cpu.convertString((int)this.cpu.getR(1));
                String s2 = this.cpu.convertString((int)this.cpu.getR(2));
                this.cpu.setR(0, s1.compareToIgnoreCase(s2));
                break;
            }
            case 323: {
                s = this.cpu.convertString(this.cpu.getR(1));
                int[] codepoints = ((String)s).codePoints().toArray();
                long resultArray = this.cpu.alloc(codepoints.length + 1);
                this.cpu.memWrite(resultArray, codepoints.length);
                for (int i = 0; i < codepoints.length; ++i) {
                    this.cpu.memWrite(resultArray + (long)i + 1L, codepoints[i]);
                }
                this.cpu.setR(0, resultArray);
                break;
            }
            case 324: {
                long addr = this.cpu.getR(1);
                int len = (int)this.cpu.memRead(addr);
                int[] codepoints = new int[len];
                for (int i = 0; i < len; ++i) {
                    codepoints[i] = (int)this.cpu.memRead(addr + (long)i + 1L);
                }
                s = new String(codepoints, 0, codepoints.length);
                this.cpu.setR(0, this.cpu.allocString((String)s));
                break;
            }
            case 325: {
                s = this.cpu.convertString(this.cpu.getR(1));
                BreakIterator bi = BreakIterator.getCharacterInstance(Locale.getDefault());
                bi.setText((String)s);
                int count = 0;
                int idx = bi.first();
                while (idx != -1) {
                    int next = bi.next();
                    if (next != -1) {
                        ++count;
                    }
                    idx = next;
                }
                this.cpu.setR(0, count);
                break;
            }
            case 326: {
                s = this.cpu.convertString(this.cpu.getR(1));
                this.cpu.setR(0, ((String)s).hashCode());
                break;
            }
            case 327: {
                s = this.cpu.convertString(this.cpu.getR(1));
                s = ((String)s).trim();
                this.cpu.setR(0, this.cpu.allocString((String)s));
                break;
            }
            case 350: {
                s = this.cpu.convertString(this.cpu.getR(1));
                String regex = this.cpu.convertString(this.cpu.getR(2));
                Pattern p = Pattern.compile(regex);
                Matcher m = p.matcher((CharSequence)s);
                this.cpu.setR(0, m.find() ? -1L : 0L);
                break;
            }
            case 351: {
                s = this.cpu.convertString(this.cpu.getR(1));
                String regex = this.cpu.convertString(this.cpu.getR(2));
                String repl = this.cpu.convertString(this.cpu.getR(3));
                s = ((String)s).replaceFirst(regex, repl);
                this.cpu.setR(0, this.cpu.allocString((String)s));
                break;
            }
            case 352: {
                s = this.cpu.convertString(this.cpu.getR(1));
                String regex = this.cpu.convertString(this.cpu.getR(2));
                String repl = this.cpu.convertString(this.cpu.getR(3));
                s = ((String)s).replaceAll(regex, repl);
                this.cpu.setR(0, this.cpu.allocString((String)s));
                break;
            }
            case 353: {
                s = this.cpu.convertString(this.cpu.getR(1));
                String regex = this.cpu.convertString(this.cpu.getR(2));
                int limit = (int)this.cpu.getR(3);
                String[] splits = limit == -1 ? ((String)s).split(regex) : ((String)s).split(regex, limit);
                long resultArray = this.cpu.alloc(splits.length + 1);
                for (int i = 1; i <= splits.length; ++i) {
                    this.cpu.memWrite(resultArray + (long)i, this.cpu.allocString(splits[i - 1]));
                }
                this.cpu.memWrite(resultArray, splits.length);
                this.cpu.setR(0, resultArray);
                break;
            }
            case 354: {
                String delim = this.cpu.convertString(this.cpu.getR(2));
                int a = (int)this.cpu.getR(1);
                int len = (int)this.cpu.memRead(a);
                s = "";
                for (int i = 1; i <= len; ++i) {
                    if (i != 1) {
                        s = (String)s + delim;
                    }
                    s = (String)s + this.cpu.convertString(this.cpu.memRead(++a));
                }
                this.cpu.setR(0, this.cpu.allocString((String)s));
                break;
            }
            case 355: {
                String s1 = this.cpu.convertString(this.cpu.getR(1));
                String s2 = this.cpu.convertString(this.cpu.getR(2));
                s = s1 + s2;
                this.cpu.setR(0, this.cpu.allocString((String)s, this.cpu.getR(3)));
                break;
            }
            default: {
                result = this.superHandler != null ? this.superHandler.dispatch(id) : false;
            }
        }
        return result;
    }

    public String sprintf(int msgOffset) throws Simulator.CPUException {
        String fmt = this.cpu.convertString(this.cpu.memRead(this.cpu.getR(29) + (long)msgOffset));
        Vector<Object> args = new Vector<Object>();
        Pattern rx = Pattern.compile("%[-+0 ]?\\d*.?\\d*([cdxefgs])", 2);
        Matcher m = rx.matcher(fmt);
        int numArgs = 0;
        while (m.find()) {
            switch (m.group(1).toLowerCase()) {
                case "c": {
                    args.add((int)this.cpu.memRead(this.cpu.getR(29) + (long)numArgs + (long)msgOffset + 1L));
                    break;
                }
                case "s": {
                    args.add(this.cpu.convertString(this.cpu.memRead(this.cpu.getR(29) + (long)numArgs + (long)msgOffset + 1L)));
                    break;
                }
                case "e": 
                case "f": 
                case "g": {
                    args.add(Double.longBitsToDouble(this.cpu.memRead(this.cpu.getR(29) + (long)numArgs + (long)msgOffset + 1L)));
                    break;
                }
                default: {
                    args.add(this.cpu.memRead(this.cpu.getR(29) + (long)numArgs + (long)msgOffset + 1L));
                }
            }
            ++numArgs;
        }
        String s = String.format(fmt, args.toArray());
        return s;
    }

    public String format(int msgOffset) throws Simulator.CPUException {
        int i;
        String fmt = this.cpu.convertString(this.cpu.memRead(this.cpu.getR(29) + (long)msgOffset));
        Vector<String> args = new Vector<String>();
        Pattern rx = Pattern.compile("\\{([0-9]*)\\}", 2);
        Matcher m = rx.matcher(fmt);
        int numArgs = 0;
        int maxArgs = 0;
        while (m.find()) {
            if (m.group(1).isEmpty()) {
                ++numArgs;
                continue;
            }
            i = Integer.parseInt(m.group(1));
            maxArgs = Math.max(maxArgs, i + 1);
        }
        numArgs = Math.max(numArgs, maxArgs);
        for (i = 0; i < numArgs; ++i) {
            args.add(this.cpu.convertString(this.cpu.memRead(this.cpu.getR(29) + (long)i + (long)msgOffset + 1L)));
        }
        String s = MessageFormat.format(StdInterruptHandler.numberPlaceholders(fmt), args.toArray());
        return s;
    }

    public static String numberPlaceholders(String template) {
        StringBuilder result = new StringBuilder();
        int count = 0;
        for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            if (c == '{' && i + 1 < template.length() && template.charAt(i + 1) == '}') {
                result.append('{').append(count++).append('}');
                ++i;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

